/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DiagnosticSupportTopic;
import java.io.IOException;
import java.util.List;

public final class DiagnosticsDefinition
implements JsonSerializable<DiagnosticsDefinition> {
    private String id;
    private String name;
    private String description;
    private String author;
    private String category;
    private List<DiagnosticSupportTopic> supportTopicList;
    private List<String> analysisTypes;
    private String type;
    private Float score;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String author() {
        return this.author;
    }

    public String category() {
        return this.category;
    }

    public List<DiagnosticSupportTopic> supportTopicList() {
        return this.supportTopicList;
    }

    public DiagnosticsDefinition withSupportTopicList(List<DiagnosticSupportTopic> supportTopicList) {
        this.supportTopicList = supportTopicList;
        return this;
    }

    public List<String> analysisTypes() {
        return this.analysisTypes;
    }

    public DiagnosticsDefinition withAnalysisTypes(List<String> analysisTypes) {
        this.analysisTypes = analysisTypes;
        return this;
    }

    public String type() {
        return this.type;
    }

    public Float score() {
        return this.score;
    }

    public void validate() {
        if (this.supportTopicList() != null) {
            this.supportTopicList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("supportTopicList", this.supportTopicList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("analysisTypes", this.analysisTypes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticsDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticsDefinition)jsonReader.readObject(reader -> {
            DiagnosticsDefinition deserializedDiagnosticsDefinition = new DiagnosticsDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.description = reader.getString();
                    continue;
                }
                if ("author".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.author = reader.getString();
                    continue;
                }
                if ("category".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.category = reader.getString();
                    continue;
                }
                if ("supportTopicList".equals(fieldName)) {
                    List supportTopicList;
                    deserializedDiagnosticsDefinition.supportTopicList = supportTopicList = reader.readArray(reader1 -> DiagnosticSupportTopic.fromJson(reader1));
                    continue;
                }
                if ("analysisTypes".equals(fieldName)) {
                    List analysisTypes;
                    deserializedDiagnosticsDefinition.analysisTypes = analysisTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.type = reader.getString();
                    continue;
                }
                if ("score".equals(fieldName)) {
                    deserializedDiagnosticsDefinition.score = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticsDefinition;
        });
    }
}

