/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DiagnosticDataTableResponseColumn;
import java.io.IOException;
import java.util.List;

public final class DiagnosticDataTableResponseObject
implements JsonSerializable<DiagnosticDataTableResponseObject> {
    private String tableName;
    private List<DiagnosticDataTableResponseColumn> columns;
    private List<Object> rows;

    public String tableName() {
        return this.tableName;
    }

    public DiagnosticDataTableResponseObject withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<DiagnosticDataTableResponseColumn> columns() {
        return this.columns;
    }

    public DiagnosticDataTableResponseObject withColumns(List<DiagnosticDataTableResponseColumn> columns) {
        this.columns = columns;
        return this;
    }

    public List<Object> rows() {
        return this.rows;
    }

    public DiagnosticDataTableResponseObject withRows(List<Object> rows) {
        this.rows = rows;
        return this;
    }

    public void validate() {
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("rows", this.rows, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticDataTableResponseObject fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticDataTableResponseObject)jsonReader.readObject(reader -> {
            DiagnosticDataTableResponseObject deserializedDiagnosticDataTableResponseObject = new DiagnosticDataTableResponseObject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tableName".equals(fieldName)) {
                    deserializedDiagnosticDataTableResponseObject.tableName = reader.getString();
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List columns;
                    deserializedDiagnosticDataTableResponseObject.columns = columns = reader.readArray(reader1 -> DiagnosticDataTableResponseColumn.fromJson(reader1));
                    continue;
                }
                if ("rows".equals(fieldName)) {
                    List rows;
                    deserializedDiagnosticDataTableResponseObject.rows = rows = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticDataTableResponseObject;
        });
    }
}

