/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AppProtocol;
import com.azure.resourcemanager.appcontainers.models.DaprAppHealth;
import com.azure.resourcemanager.appcontainers.models.LogLevel;
import java.io.IOException;

public final class Dapr
implements JsonSerializable<Dapr> {
    private Boolean enabled;
    private String appId;
    private AppProtocol appProtocol;
    private Integer appPort;
    private Integer httpReadBufferSize;
    private Integer httpMaxRequestSize;
    private LogLevel logLevel;
    private Boolean enableApiLogging;
    private DaprAppHealth appHealth;
    private Integer maxConcurrency;

    public Boolean enabled() {
        return this.enabled;
    }

    public Dapr withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public Dapr withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public AppProtocol appProtocol() {
        return this.appProtocol;
    }

    public Dapr withAppProtocol(AppProtocol appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    public Integer appPort() {
        return this.appPort;
    }

    public Dapr withAppPort(Integer appPort) {
        this.appPort = appPort;
        return this;
    }

    public Integer httpReadBufferSize() {
        return this.httpReadBufferSize;
    }

    public Dapr withHttpReadBufferSize(Integer httpReadBufferSize) {
        this.httpReadBufferSize = httpReadBufferSize;
        return this;
    }

    public Integer httpMaxRequestSize() {
        return this.httpMaxRequestSize;
    }

    public Dapr withHttpMaxRequestSize(Integer httpMaxRequestSize) {
        this.httpMaxRequestSize = httpMaxRequestSize;
        return this;
    }

    public LogLevel logLevel() {
        return this.logLevel;
    }

    public Dapr withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public Boolean enableApiLogging() {
        return this.enableApiLogging;
    }

    public Dapr withEnableApiLogging(Boolean enableApiLogging) {
        this.enableApiLogging = enableApiLogging;
        return this;
    }

    public DaprAppHealth appHealth() {
        return this.appHealth;
    }

    public Dapr withAppHealth(DaprAppHealth appHealth) {
        this.appHealth = appHealth;
        return this;
    }

    public Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public Dapr withMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public void validate() {
        if (this.appHealth() != null) {
            this.appHealth().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("appId", this.appId);
        jsonWriter.writeStringField("appProtocol", this.appProtocol == null ? null : this.appProtocol.toString());
        jsonWriter.writeNumberField("appPort", (Number)this.appPort);
        jsonWriter.writeNumberField("httpReadBufferSize", (Number)this.httpReadBufferSize);
        jsonWriter.writeNumberField("httpMaxRequestSize", (Number)this.httpMaxRequestSize);
        jsonWriter.writeStringField("logLevel", this.logLevel == null ? null : this.logLevel.toString());
        jsonWriter.writeBooleanField("enableApiLogging", this.enableApiLogging);
        jsonWriter.writeJsonField("appHealth", (JsonSerializable)this.appHealth);
        jsonWriter.writeNumberField("maxConcurrency", (Number)this.maxConcurrency);
        return jsonWriter.writeEndObject();
    }

    public static Dapr fromJson(JsonReader jsonReader) throws IOException {
        return (Dapr)jsonReader.readObject(reader -> {
            Dapr deserializedDapr = new Dapr();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedDapr.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appId".equals(fieldName)) {
                    deserializedDapr.appId = reader.getString();
                    continue;
                }
                if ("appProtocol".equals(fieldName)) {
                    deserializedDapr.appProtocol = AppProtocol.fromString(reader.getString());
                    continue;
                }
                if ("appPort".equals(fieldName)) {
                    deserializedDapr.appPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpReadBufferSize".equals(fieldName)) {
                    deserializedDapr.httpReadBufferSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("httpMaxRequestSize".equals(fieldName)) {
                    deserializedDapr.httpMaxRequestSize = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("logLevel".equals(fieldName)) {
                    deserializedDapr.logLevel = LogLevel.fromString(reader.getString());
                    continue;
                }
                if ("enableApiLogging".equals(fieldName)) {
                    deserializedDapr.enableApiLogging = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appHealth".equals(fieldName)) {
                    deserializedDapr.appHealth = DaprAppHealth.fromJson(reader);
                    continue;
                }
                if ("maxConcurrency".equals(fieldName)) {
                    deserializedDapr.maxConcurrency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDapr;
        });
    }
}

