/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.BindingType;
import java.io.IOException;

public final class CustomDomain
implements JsonSerializable<CustomDomain> {
    private String name;
    private BindingType bindingType;
    private String certificateId;
    private static final ClientLogger LOGGER = new ClientLogger(CustomDomain.class);

    public String name() {
        return this.name;
    }

    public CustomDomain withName(String name) {
        this.name = name;
        return this;
    }

    public BindingType bindingType() {
        return this.bindingType;
    }

    public CustomDomain withBindingType(BindingType bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CustomDomain withCertificateId(String certificateId) {
        this.certificateId = certificateId;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CustomDomain"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("bindingType", this.bindingType == null ? null : this.bindingType.toString());
        jsonWriter.writeStringField("certificateId", this.certificateId);
        return jsonWriter.writeEndObject();
    }

    public static CustomDomain fromJson(JsonReader jsonReader) throws IOException {
        return (CustomDomain)jsonReader.readObject(reader -> {
            CustomDomain deserializedCustomDomain = new CustomDomain();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCustomDomain.name = reader.getString();
                    continue;
                }
                if ("bindingType".equals(fieldName)) {
                    deserializedCustomDomain.bindingType = BindingType.fromString(reader.getString());
                    continue;
                }
                if ("certificateId".equals(fieldName)) {
                    deserializedCustomDomain.certificateId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomDomain;
        });
    }
}

