/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.CertificateInner;
import java.io.IOException;
import java.util.List;

public final class CertificateCollection
implements JsonSerializable<CertificateCollection> {
    private List<CertificateInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CertificateCollection.class);

    public List<CertificateInner> value() {
        return this.value;
    }

    public CertificateCollection withValue(List<CertificateInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CertificateCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CertificateCollection fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateCollection)jsonReader.readObject(reader -> {
            CertificateCollection deserializedCertificateCollection = new CertificateCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCertificateCollection.value = value = reader.readArray(reader1 -> CertificateInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCertificateCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateCollection;
        });
    }
}

