/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ManagedEnvironmentPrivateLinkResourcesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.appcontainers.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironmentPrivateLinkResources;
import com.azure.resourcemanager.appcontainers.models.PrivateLinkResource;

public final class ManagedEnvironmentPrivateLinkResourcesImpl
implements ManagedEnvironmentPrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedEnvironmentPrivateLinkResourcesImpl.class);
    private final ManagedEnvironmentPrivateLinkResourcesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ManagedEnvironmentPrivateLinkResourcesImpl(ManagedEnvironmentPrivateLinkResourcesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String environmentName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, environmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String environmentName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, environmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    private ManagedEnvironmentPrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }
}

