/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.ConnectedEnvironmentsCertificatesClient;
import com.azure.resourcemanager.appcontainers.fluent.models.CertificateInner;
import com.azure.resourcemanager.appcontainers.implementation.CertificateImpl;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.Certificate;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentsCertificates;

public final class ConnectedEnvironmentsCertificatesImpl
implements ConnectedEnvironmentsCertificates {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedEnvironmentsCertificatesImpl.class);
    private final ConnectedEnvironmentsCertificatesClient innerClient;
    private final ContainerAppsApiManager serviceManager;

    public ConnectedEnvironmentsCertificatesImpl(ConnectedEnvironmentsCertificatesClient innerClient, ContainerAppsApiManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Certificate> list(String resourceGroupName, String connectedEnvironmentName) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, connectedEnvironmentName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Certificate> list(String resourceGroupName, String connectedEnvironmentName, Context context) {
        PagedIterable<CertificateInner> inner = this.serviceClient().list(resourceGroupName, connectedEnvironmentName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CertificateImpl((CertificateInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Certificate> getWithResponse(String resourceGroupName, String connectedEnvironmentName, String certificateName, Context context) {
        Response<CertificateInner> inner = this.serviceClient().getWithResponse(resourceGroupName, connectedEnvironmentName, certificateName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CertificateImpl((CertificateInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Certificate get(String resourceGroupName, String connectedEnvironmentName, String certificateName) {
        CertificateInner inner = this.serviceClient().get(resourceGroupName, connectedEnvironmentName, certificateName);
        if (inner != null) {
            return new CertificateImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String connectedEnvironmentName, String certificateName) {
        this.serviceClient().delete(resourceGroupName, connectedEnvironmentName, certificateName);
    }

    @Override
    public void delete(String resourceGroupName, String connectedEnvironmentName, String certificateName, Context context) {
        this.serviceClient().delete(resourceGroupName, connectedEnvironmentName, certificateName, context);
    }

    @Override
    public Certificate getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        return (Certificate)this.getWithResponse(resourceGroupName, connectedEnvironmentName, certificateName, Context.NONE).getValue();
    }

    @Override
    public Response<Certificate> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        return this.getWithResponse(resourceGroupName, connectedEnvironmentName, certificateName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        this.delete(resourceGroupName, connectedEnvironmentName, certificateName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(id, "connectedEnvironments");
        if (connectedEnvironmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'connectedEnvironments'.", id)));
        }
        String certificateName = ResourceManagerUtils.getValueFromIdByName(id, "certificates");
        if (certificateName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'certificates'.", id)));
        }
        this.delete(resourceGroupName, connectedEnvironmentName, certificateName, context);
    }

    private ConnectedEnvironmentsCertificatesClient serviceClient() {
        return this.innerClient;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public CertificateImpl define(String name) {
        return new CertificateImpl(name, this.manager());
    }
}

