/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.ConnectedEnvironmentInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentPatchResource;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import com.azure.resourcemanager.appcontainers.models.ExtendedLocation;
import java.util.Collections;
import java.util.Map;

public final class ConnectedEnvironmentImpl
implements ConnectedEnvironment,
ConnectedEnvironment.Definition,
ConnectedEnvironment.Update {
    private ConnectedEnvironmentInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String connectedEnvironmentName;
    private ConnectedEnvironmentPatchResource updateEnvironmentEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ConnectedEnvironmentProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String deploymentErrors() {
        return this.innerModel().deploymentErrors();
    }

    @Override
    public String defaultDomain() {
        return this.innerModel().defaultDomain();
    }

    @Override
    public String staticIp() {
        return this.innerModel().staticIp();
    }

    @Override
    public String daprAIConnectionString() {
        return this.innerModel().daprAIConnectionString();
    }

    @Override
    public CustomDomainConfiguration customDomainConfiguration() {
        return this.innerModel().customDomainConfiguration();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConnectedEnvironmentInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConnectedEnvironmentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ConnectedEnvironment create() {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironments().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ConnectedEnvironment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConnectedEnvironments().createOrUpdate(this.resourceGroupName, this.connectedEnvironmentName, this.innerModel(), context);
        return this;
    }

    ConnectedEnvironmentImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new ConnectedEnvironmentInner();
        this.serviceManager = serviceManager;
        this.connectedEnvironmentName = name;
    }

    @Override
    public ConnectedEnvironmentImpl update() {
        this.updateEnvironmentEnvelope = new ConnectedEnvironmentPatchResource();
        return this;
    }

    @Override
    public ConnectedEnvironment apply() {
        this.innerObject = (ConnectedEnvironmentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironments().updateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.updateEnvironmentEnvelope, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironment apply(Context context) {
        this.innerObject = (ConnectedEnvironmentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironments().updateWithResponse(this.resourceGroupName, this.connectedEnvironmentName, this.updateEnvironmentEnvelope, context).getValue());
        return this;
    }

    ConnectedEnvironmentImpl(ConnectedEnvironmentInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.connectedEnvironmentName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "connectedEnvironments");
    }

    @Override
    public ConnectedEnvironment refresh() {
        this.innerObject = (ConnectedEnvironmentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironments().getByResourceGroupWithResponse(this.resourceGroupName, this.connectedEnvironmentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConnectedEnvironment refresh(Context context) {
        this.innerObject = (ConnectedEnvironmentInner)((Object)this.serviceManager.serviceClient().getConnectedEnvironments().getByResourceGroupWithResponse(this.resourceGroupName, this.connectedEnvironmentName, context).getValue());
        return this;
    }

    @Override
    public Response<CheckNameAvailabilityResponse> checkNameAvailabilityWithResponse(CheckNameAvailabilityRequest checkNameAvailabilityRequest, Context context) {
        return this.serviceManager.connectedEnvironments().checkNameAvailabilityWithResponse(this.resourceGroupName, this.connectedEnvironmentName, checkNameAvailabilityRequest, context);
    }

    @Override
    public CheckNameAvailabilityResponse checkNameAvailability(CheckNameAvailabilityRequest checkNameAvailabilityRequest) {
        return this.serviceManager.connectedEnvironments().checkNameAvailability(this.resourceGroupName, this.connectedEnvironmentName, checkNameAvailabilityRequest);
    }

    @Override
    public ConnectedEnvironmentImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateEnvironmentEnvelope.withTags((Map)tags);
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withStaticIp(String staticIp) {
        this.innerModel().withStaticIp(staticIp);
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withDaprAIConnectionString(String daprAIConnectionString) {
        this.innerModel().withDaprAIConnectionString(daprAIConnectionString);
        return this;
    }

    @Override
    public ConnectedEnvironmentImpl withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        this.innerModel().withCustomDomainConfiguration(customDomainConfiguration);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

