/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ScheduledEntry;
import java.io.IOException;
import java.util.List;

public final class ScheduledEntries
implements JsonSerializable<ScheduledEntries> {
    private List<ScheduledEntry> scheduledEntries;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduledEntries.class);

    public List<ScheduledEntry> scheduledEntries() {
        return this.scheduledEntries;
    }

    public ScheduledEntries withScheduledEntries(List<ScheduledEntry> scheduledEntries) {
        this.scheduledEntries = scheduledEntries;
        return this;
    }

    public void validate() {
        if (this.scheduledEntries() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scheduledEntries in model ScheduledEntries"));
        }
        this.scheduledEntries().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("scheduledEntries", this.scheduledEntries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ScheduledEntries fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledEntries)jsonReader.readObject(reader -> {
            ScheduledEntries deserializedScheduledEntries = new ScheduledEntries();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduledEntries".equals(fieldName)) {
                    List scheduledEntries;
                    deserializedScheduledEntries.scheduledEntries = scheduledEntries = reader.readArray(reader1 -> ScheduledEntry.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledEntries;
        });
    }
}

