/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.OperationDisplay;
import java.io.IOException;

public final class OperationDetailInner
implements JsonSerializable<OperationDetailInner> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;
    private String origin;

    public String name() {
        return this.name;
    }

    public OperationDetailInner withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationDetailInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationDetailInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationDetailInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        return jsonWriter.writeEndObject();
    }

    public static OperationDetailInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDetailInner)jsonReader.readObject(reader -> {
            OperationDetailInner deserializedOperationDetailInner = new OperationDetailInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationDetailInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationDetailInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationDetailInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationDetailInner.origin = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationDetailInner;
        });
    }
}

