/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.HttpRouteConfigProperties;
import java.io.IOException;

public final class HttpRouteConfigInner
extends ProxyResource {
    private HttpRouteConfigProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public HttpRouteConfigProperties properties() {
        return this.properties;
    }

    public HttpRouteConfigInner withProperties(HttpRouteConfigProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static HttpRouteConfigInner fromJson(JsonReader jsonReader) throws IOException {
        return (HttpRouteConfigInner)((Object)jsonReader.readObject(reader -> {
            HttpRouteConfigInner deserializedHttpRouteConfigInner = new HttpRouteConfigInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHttpRouteConfigInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHttpRouteConfigInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpRouteConfigInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedHttpRouteConfigInner.properties = HttpRouteConfigProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedHttpRouteConfigInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHttpRouteConfigInner;
        }));
    }
}

