/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.DaprComponentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.DaprMetadata;
import com.azure.resourcemanager.appcontainers.models.Secret;
import java.io.IOException;
import java.util.List;

public final class DaprComponentProperties
implements JsonSerializable<DaprComponentProperties> {
    private String componentType;
    private String version;
    private Boolean ignoreErrors;
    private String initTimeout;
    private List<Secret> secrets;
    private String secretStoreComponent;
    private List<DaprMetadata> metadata;
    private List<String> scopes;
    private DaprComponentProvisioningState provisioningState;
    private String deploymentErrors;

    public String componentType() {
        return this.componentType;
    }

    public DaprComponentProperties withComponentType(String componentType) {
        this.componentType = componentType;
        return this;
    }

    public String version() {
        return this.version;
    }

    public DaprComponentProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public Boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    public DaprComponentProperties withIgnoreErrors(Boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return this;
    }

    public String initTimeout() {
        return this.initTimeout;
    }

    public DaprComponentProperties withInitTimeout(String initTimeout) {
        this.initTimeout = initTimeout;
        return this;
    }

    public List<Secret> secrets() {
        return this.secrets;
    }

    public DaprComponentProperties withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public String secretStoreComponent() {
        return this.secretStoreComponent;
    }

    public DaprComponentProperties withSecretStoreComponent(String secretStoreComponent) {
        this.secretStoreComponent = secretStoreComponent;
        return this;
    }

    public List<DaprMetadata> metadata() {
        return this.metadata;
    }

    public DaprComponentProperties withMetadata(List<DaprMetadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public DaprComponentProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public DaprComponentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("componentType", this.componentType);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeBooleanField("ignoreErrors", this.ignoreErrors);
        jsonWriter.writeStringField("initTimeout", this.initTimeout);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("secretStoreComponent", this.secretStoreComponent);
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DaprComponentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DaprComponentProperties)jsonReader.readObject(reader -> {
            DaprComponentProperties deserializedDaprComponentProperties = new DaprComponentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("componentType".equals(fieldName)) {
                    deserializedDaprComponentProperties.componentType = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDaprComponentProperties.version = reader.getString();
                    continue;
                }
                if ("ignoreErrors".equals(fieldName)) {
                    deserializedDaprComponentProperties.ignoreErrors = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("initTimeout".equals(fieldName)) {
                    deserializedDaprComponentProperties.initTimeout = reader.getString();
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedDaprComponentProperties.secrets = secrets = reader.readArray(reader1 -> Secret.fromJson(reader1));
                    continue;
                }
                if ("secretStoreComponent".equals(fieldName)) {
                    deserializedDaprComponentProperties.secretStoreComponent = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedDaprComponentProperties.metadata = metadata = reader.readArray(reader1 -> DaprMetadata.fromJson(reader1));
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedDaprComponentProperties.scopes = scopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDaprComponentProperties.provisioningState = DaprComponentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedDaprComponentProperties.deploymentErrors = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprComponentProperties;
        });
    }
}

