/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueStorageError
implements JsonSerializable<QueueStorageError>,
XmlSerializable<QueueStorageError> {
    private String code;
    private String message;
    private String queryParameterName;
    private String queryParameterValue;
    private String reason;
    private String extendedErrorDetail;
    private String headerName;
    private String headerValue;

    private QueueStorageError() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject("Error").writeStringField("Code", this.code).writeStringField("Message", this.message).writeStringField("QueryParameterName", this.queryParameterName).writeStringField("QueryParameterValue", this.queryParameterValue).writeStringField("Reason", this.reason).writeStringField("ExtendedErrorDetail", this.extendedErrorDetail).writeEndObject();
    }

    public static QueueStorageError fromJson(JsonReader jsonReader) throws IOException {
        return (QueueStorageError)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return QueueStorageError.readQueueError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return QueueStorageError.readQueueError(bufferedReader.reset());
        });
    }

    private static QueueStorageError readQueueError(JsonReader jsonReader) throws IOException {
        return (QueueStorageError)jsonReader.readObject(reader -> {
            QueueStorageError deserializedStorageError = new QueueStorageError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedStorageError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedStorageError.message = reader.getString();
                    continue;
                }
                if ("queryParameterName".equals(fieldName)) {
                    deserializedStorageError.queryParameterName = reader.getString();
                    continue;
                }
                if ("queryParameterValue".equals(fieldName)) {
                    deserializedStorageError.queryParameterValue = reader.getString();
                    continue;
                }
                if ("reason".equals(fieldName)) {
                    deserializedStorageError.reason = reader.getString();
                    continue;
                }
                if ("extendedErrorDetail".equals(fieldName)) {
                    deserializedStorageError.extendedErrorDetail = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageError;
        });
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Error" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Code", this.code);
        xmlWriter.writeStringElement("Message", this.message);
        xmlWriter.writeStringElement("QueryParameterName", this.queryParameterName);
        xmlWriter.writeStringElement("QueryParameterValue", this.queryParameterValue);
        xmlWriter.writeStringElement("Reason", this.reason);
        xmlWriter.writeStringElement("ExtendedErrorDetail", this.extendedErrorDetail);
        xmlWriter.writeStringElement("HeaderName", this.headerName);
        xmlWriter.writeStringElement("HeaderValue", this.headerValue);
        return xmlWriter.writeEndElement();
    }

    public static QueueStorageError fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueStorageError.fromXml(xmlReader, null);
    }

    public static QueueStorageError fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Error" : rootElementName;
        return (QueueStorageError)xmlReader.readObject(finalRootElementName, reader -> {
            QueueStorageError deserializedStorageError = new QueueStorageError();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Code".equals(elementName.getLocalPart())) {
                    deserializedStorageError.code = reader.getStringElement();
                    continue;
                }
                if ("Message".equals(elementName.getLocalPart())) {
                    deserializedStorageError.message = reader.getStringElement();
                    continue;
                }
                if ("QueryParameterName".equals(elementName.getLocalPart())) {
                    deserializedStorageError.queryParameterName = reader.getStringElement();
                    continue;
                }
                if ("QueryParameterValue".equals(elementName.getLocalPart())) {
                    deserializedStorageError.queryParameterValue = reader.getStringElement();
                    continue;
                }
                if ("Reason".equals(elementName.getLocalPart())) {
                    deserializedStorageError.reason = reader.getStringElement();
                    continue;
                }
                if ("ExtendedErrorDetail".equals(elementName.getLocalPart())) {
                    deserializedStorageError.extendedErrorDetail = reader.getStringElement();
                    continue;
                }
                if ("HeaderName".equals(elementName.getLocalPart())) {
                    deserializedStorageError.headerName = reader.getStringElement();
                    continue;
                }
                if (!"HeaderValue".equals(elementName.getLocalPart())) continue;
                deserializedStorageError.headerValue = reader.getStringElement();
            }
            return deserializedStorageError;
        });
    }
}

