/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.queue.models.GeoReplicationStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class GeoReplication
implements XmlSerializable<GeoReplication> {
    private GeoReplicationStatus status;
    private DateTimeRfc1123 lastSyncTime;

    public GeoReplicationStatus getStatus() {
        return this.status;
    }

    public GeoReplication setStatus(GeoReplicationStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getLastSyncTime() {
        if (this.lastSyncTime == null) {
            return null;
        }
        return this.lastSyncTime.getDateTime();
    }

    public GeoReplication setLastSyncTime(OffsetDateTime lastSyncTime) {
        this.lastSyncTime = lastSyncTime == null ? null : new DateTimeRfc1123(lastSyncTime);
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "GeoReplication" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement("LastSyncTime", Objects.toString(this.lastSyncTime, null));
        return xmlWriter.writeEndElement();
    }

    public static GeoReplication fromXml(XmlReader xmlReader) throws XMLStreamException {
        return GeoReplication.fromXml(xmlReader, null);
    }

    public static GeoReplication fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "GeoReplication" : rootElementName;
        return (GeoReplication)xmlReader.readObject(finalRootElementName, reader -> {
            GeoReplication deserializedGeoReplication = new GeoReplication();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Status".equals(elementName.getLocalPart())) {
                    deserializedGeoReplication.status = GeoReplicationStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("LastSyncTime".equals(elementName.getLocalPart())) {
                    deserializedGeoReplication.lastSyncTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedGeoReplication;
        });
    }
}

