/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.data.cosmos.core.mapping.event;

import com.azure.spring.data.cosmos.core.mapping.event.AfterLoadEvent;
import com.azure.spring.data.cosmos.core.mapping.event.CosmosMappingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;

public abstract class AbstractCosmosEventListener<E>
implements ApplicationListener<CosmosMappingEvent<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCosmosEventListener.class);
    private final Class<?> domainClass;

    public AbstractCosmosEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractCosmosEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(CosmosMappingEvent<?> event) {
        AfterLoadEvent afterLoadEvent;
        if (event instanceof AfterLoadEvent && this.domainClass.isAssignableFrom((afterLoadEvent = (AfterLoadEvent)event).getType())) {
            this.onAfterLoad((AfterLoadEvent)event);
        }
    }

    public void onAfterLoad(AfterLoadEvent<E> event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onAfterLoad({})", (Object)event.getDocument());
        }
    }
}

