/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.utils;

import com.azure.security.keyvault.jca.implementation.model.AccessToken;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.azure.security.keyvault.jca.implementation.utils.HttpUtil;
import com.azure.security.keyvault.jca.implementation.utils.JsonConverterUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AccessTokenUtil {
    private static final String CLIENT_ID_FRAGMENT = "&client_id=";
    private static final String CLIENT_SECRET_FRAGMENT = "&client_secret=";
    private static final String GRANT_TYPE_FRAGMENT = "grant_type=client_credentials";
    private static final String RESOURCE_FRAGMENT = "&resource=";
    private static final String OAUTH2_TOKEN_BASE_URL = "https://login.microsoftonline.com/";
    private static final String OAUTH2_TOKEN_POSTFIX = "oauth2/token";
    private static final String OAUTH2_MANAGED_IDENTITY_TOKEN_URL = "http://169.254.169.254/metadata/identity/oauth2/token?api-version=2018-02-01";
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final Logger LOGGER = Logger.getLogger(AccessTokenUtil.class.getName());
    private static final String PROPERTY_IDENTITY_ENDPOINT = "IDENTITY_ENDPOINT";
    private static final String PROPERTY_IDENTITY_HEADER = "IDENTITY_HEADER";

    public static AccessToken getAccessToken(String resource, String identity) {
        AccessToken result = System.getenv("WEBSITE_SITE_NAME") != null && !System.getenv("WEBSITE_SITE_NAME").isEmpty() ? AccessTokenUtil.getAccessTokenOnAppService(resource, identity) : (System.getenv(PROPERTY_IDENTITY_ENDPOINT) != null && !System.getenv(PROPERTY_IDENTITY_ENDPOINT).isEmpty() ? AccessTokenUtil.getAccessTokenOnContainerApp(resource, identity) : AccessTokenUtil.getAccessTokenOnOthers(resource, identity));
        return result;
    }

    public static AccessToken getAccessToken(String resource, String aadAuthenticationUrl, String tenantId, String clientId, String clientSecret) {
        LOGGER.entering("AccessTokenUtil", "getAccessToken", new Object[]{resource, tenantId, clientId, clientSecret});
        LOGGER.info("Getting access token using client ID / client secret");
        AccessToken result = null;
        StringBuilder oauth2Url = new StringBuilder();
        if (aadAuthenticationUrl == null) {
            oauth2Url.append(OAUTH2_TOKEN_BASE_URL).append(tenantId).append("/");
        } else {
            oauth2Url.append(HttpUtil.addTrailingSlashIfRequired(aadAuthenticationUrl));
        }
        oauth2Url.append(OAUTH2_TOKEN_POSTFIX);
        String encodedClientSecret = "";
        try {
            encodedClientSecret = URLEncoder.encode(clientSecret, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Failed to encode client secret for access token request", e);
        }
        StringBuilder requestBody = new StringBuilder();
        requestBody.append(GRANT_TYPE_FRAGMENT).append(CLIENT_ID_FRAGMENT).append(clientId).append(CLIENT_SECRET_FRAGMENT).append(encodedClientSecret).append(RESOURCE_FRAGMENT).append(resource);
        String body = HttpUtil.post(oauth2Url.toString(), requestBody.toString(), "application/x-www-form-urlencoded");
        if (body != null) {
            try {
                result = JsonConverterUtil.fromJson(AccessToken::fromJson, body);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to parse access token response.", e);
            }
        }
        LOGGER.exiting("AccessTokenUtil", "getAccessToken", result);
        return result;
    }

    private static AccessToken getAccessTokenOnAppService(String resource, String clientId) {
        LOGGER.entering("AccessTokenUtil", "getAccessTokenOnAppService", resource);
        LOGGER.info("Getting access token using managed identity based on MSI_SECRET");
        AccessToken result = null;
        StringBuilder url = new StringBuilder();
        url.append(System.getenv("MSI_ENDPOINT")).append("?api-version=2017-09-01").append(RESOURCE_FRAGMENT).append(resource);
        if (clientId != null) {
            url.append("&clientid=").append(clientId);
            LOGGER.log(Level.INFO, "Using managed identity with client ID: {0}", clientId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata", "true");
        headers.put("Secret", System.getenv("MSI_SECRET"));
        String body = HttpUtil.get(url.toString(), headers);
        if (body != null) {
            try {
                result = JsonConverterUtil.fromJson(AccessToken::fromJson, body);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to parse access token response.", e);
            }
        }
        LOGGER.exiting("AccessTokenUtil", "getAccessTokenOnAppService", result);
        return result;
    }

    private static AccessToken getAccessTokenOnContainerApp(String resource, String clientId) {
        String body;
        LOGGER.entering("AccessTokenUtil", "getAccessTokenOnContainerApp", resource);
        LOGGER.info("Getting access token using managed identity.");
        AccessToken result = null;
        StringBuilder url = new StringBuilder();
        url.append(System.getenv(PROPERTY_IDENTITY_ENDPOINT)).append("?api-version=2019-08-01").append(RESOURCE_FRAGMENT).append(resource);
        if (clientId != null) {
            url.append(CLIENT_ID_FRAGMENT).append(clientId);
            LOGGER.log(Level.INFO, "Using managed identity with client ID: {0}", clientId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (System.getenv(PROPERTY_IDENTITY_HEADER) != null && !System.getenv(PROPERTY_IDENTITY_HEADER).isEmpty()) {
            headers.put("X-IDENTITY-HEADER", System.getenv(PROPERTY_IDENTITY_HEADER));
        }
        if ((body = HttpUtil.get(url.toString(), headers)) != null) {
            try {
                result = JsonConverterUtil.fromJson(AccessToken::fromJson, body);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to parse access token response.", e);
            }
        }
        LOGGER.exiting("AccessTokenUtil", "getAccessTokenOnContainerApp", result);
        return result;
    }

    private static AccessToken getAccessTokenOnOthers(String resource, String identity) {
        LOGGER.entering("AccessTokenUtil", "getAccessTokenOnOthers", resource);
        LOGGER.info("Getting access token using managed identity");
        if (identity != null) {
            LOGGER.log(Level.INFO, "Using managed identity with object ID: {0}", identity);
        }
        AccessToken result = null;
        StringBuilder url = new StringBuilder();
        url.append(OAUTH2_MANAGED_IDENTITY_TOKEN_URL).append(RESOURCE_FRAGMENT).append(resource);
        if (identity != null) {
            url.append("&object_id=").append(identity);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata", "true");
        String body = HttpUtil.get(url.toString(), headers);
        if (body != null) {
            try {
                result = JsonConverterUtil.fromJson(AccessToken::fromJson, body);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to parse access token response.", e);
            }
        }
        LOGGER.exiting("AccessTokenUtil", "getAccessTokenOnOthers", result);
        return result;
    }

    public static String getLoginUri(String resourceUri, boolean disableChallengeResourceVerification) {
        LOGGER.entering("AccessTokenUtil", "getLoginUri", resourceUri);
        LOGGER.log(Level.INFO, "Getting login URI using: {0}", resourceUri);
        ClassicHttpResponse response = HttpUtil.getWithResponse(resourceUri, null);
        if (response == null) {
            throw new IllegalStateException("Could not obtain login URI to retrieve access token from.");
        }
        Map<String, String> challengeAttributes = AccessTokenUtil.extractChallengeAttributes(response.getFirstHeader(WWW_AUTHENTICATE).getValue());
        String scope = challengeAttributes.get("resource");
        scope = scope != null ? scope + "/.default" : challengeAttributes.get("scope");
        if (scope == null) {
            return null;
        }
        if (!disableChallengeResourceVerification && !AccessTokenUtil.isChallengeResourceValid(resourceUri, scope)) {
            throw new IllegalStateException("The challenge resource " + scope + " does not match the requested domain. If you wish to disable this check, set the environment property 'azure.keyvault.disable-challenge-resource-verification' to 'true'. See https://aka.ms/azsdk/blog/vault-uri for more information.");
        }
        String authorization = challengeAttributes.get("authorization");
        if (authorization == null) {
            authorization = challengeAttributes.get("authorization_uri");
        }
        try {
            new URI(authorization);
            LOGGER.log(Level.INFO, "Obtained login URI: {0}", authorization);
            LOGGER.exiting("AccessTokenUtil", "getLoginUri", authorization);
            return authorization;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The challenge authorization URI " + authorization + " is invalid.", e);
        }
    }

    private static Map<String, String> extractChallengeAttributes(String authenticateHeader) {
        LOGGER.entering("AccessTokenUtil", "extractChallengeAttributes", authenticateHeader);
        if (!AccessTokenUtil.isBearerChallenge(authenticateHeader)) {
            return Collections.emptyMap();
        }
        authenticateHeader = authenticateHeader.toLowerCase(Locale.ROOT).replace(BEARER_TOKEN_PREFIX.toLowerCase(Locale.ROOT), "");
        String[] attributes = authenticateHeader.split(", ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        LOGGER.exiting("AccessTokenUtil", "extractChallengeAttributes", attributeMap);
        return attributeMap;
    }

    private static boolean isBearerChallenge(String authenticateHeader) {
        return authenticateHeader != null && !authenticateHeader.isEmpty() && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(BEARER_TOKEN_PREFIX.toLowerCase(Locale.ROOT));
    }

    private static boolean isChallengeResourceValid(String resource, String scope) {
        URI scopeUri;
        URI resourceUri;
        LOGGER.entering("AccessTokenUtil", "isChallengeResourceValid", new Object[]{resource, scope});
        try {
            resourceUri = new URI(resource);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The provided resource " + resource + " is not a valid URI.", e);
        }
        try {
            scopeUri = new URI(scope);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The challenge scope " + scope + " is not a valid URI.", e);
        }
        boolean isValid = resourceUri.getHost().toLowerCase(Locale.ROOT).endsWith("." + scopeUri.getHost().toLowerCase(Locale.ROOT));
        LOGGER.exiting("AccessTokenUtil", "isChallengeResourceValid", isValid);
        return isValid;
    }
}

