/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.ECFieldElement;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.ec.custom.sec.SecP256K1Field;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.math.raw.Nat256;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.Arrays;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP256K1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F"));
    protected int[] x;

    public SecP256K1FieldElement(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(Q) >= 0) {
            throw new IllegalArgumentException("x value invalid for SecP256K1FieldElement");
        }
        this.x = SecP256K1Field.fromBigInteger((BigInteger)bigInteger);
    }

    public SecP256K1FieldElement() {
        this.x = Nat256.create();
    }

    protected SecP256K1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    @Override
    public boolean isZero() {
        return Nat256.isZero((int[])this.x);
    }

    @Override
    public boolean isOne() {
        return Nat256.isOne((int[])this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat256.getBit((int[])this.x, (int)0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat256.toBigInteger((int[])this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP256K1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.add((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement addOne() {
        int[] nArray = Nat256.create();
        SecP256K1Field.addOne((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.subtract((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.multiply((int[])this.x, (int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat256.create();
        SecP256K1Field.inv((int[])((SecP256K1FieldElement)eCFieldElement).x, (int[])nArray);
        SecP256K1Field.multiply((int[])nArray, (int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        int[] nArray = Nat256.create();
        SecP256K1Field.negate((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement square() {
        int[] nArray = Nat256.create();
        SecP256K1Field.square((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement invert() {
        int[] nArray = Nat256.create();
        SecP256K1Field.inv((int[])this.x, (int[])nArray);
        return new SecP256K1FieldElement(nArray);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = this.x;
        if (Nat256.isZero((int[])nArray) || Nat256.isOne((int[])nArray)) {
            return this;
        }
        int[] nArray2 = Nat256.createExt();
        int[] nArray3 = Nat256.create();
        SecP256K1Field.square((int[])nArray, (int[])nArray3, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray3, (int[])nArray, (int[])nArray3, (int[])nArray2);
        int[] nArray4 = Nat256.create();
        SecP256K1Field.square((int[])nArray3, (int[])nArray4, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray4, (int[])nArray, (int[])nArray4, (int[])nArray2);
        int[] nArray5 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray4, (int)3, (int[])nArray5, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray5, (int[])nArray4, (int[])nArray5, (int[])nArray2);
        int[] nArray6 = nArray5;
        SecP256K1Field.squareN((int[])nArray5, (int)3, (int[])nArray6, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray6, (int[])nArray4, (int[])nArray6, (int[])nArray2);
        int[] nArray7 = nArray6;
        SecP256K1Field.squareN((int[])nArray6, (int)2, (int[])nArray7, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray7, (int[])nArray3, (int[])nArray7, (int[])nArray2);
        int[] nArray8 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray7, (int)11, (int[])nArray8, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray8, (int[])nArray7, (int[])nArray8, (int[])nArray2);
        int[] nArray9 = nArray7;
        SecP256K1Field.squareN((int[])nArray8, (int)22, (int[])nArray9, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray9, (int[])nArray8, (int[])nArray9, (int[])nArray2);
        int[] nArray10 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray9, (int)44, (int[])nArray10, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray10, (int[])nArray9, (int[])nArray10, (int[])nArray2);
        int[] nArray11 = Nat256.create();
        SecP256K1Field.squareN((int[])nArray10, (int)88, (int[])nArray11, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray11, (int[])nArray10, (int[])nArray11, (int[])nArray2);
        int[] nArray12 = nArray10;
        SecP256K1Field.squareN((int[])nArray11, (int)44, (int[])nArray12, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray12, (int[])nArray9, (int[])nArray12, (int[])nArray2);
        int[] nArray13 = nArray9;
        SecP256K1Field.squareN((int[])nArray12, (int)3, (int[])nArray13, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray13, (int[])nArray4, (int[])nArray13, (int[])nArray2);
        int[] nArray14 = nArray13;
        SecP256K1Field.squareN((int[])nArray14, (int)23, (int[])nArray14, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray14, (int[])nArray8, (int[])nArray14, (int[])nArray2);
        SecP256K1Field.squareN((int[])nArray14, (int)6, (int[])nArray14, (int[])nArray2);
        SecP256K1Field.multiply((int[])nArray14, (int[])nArray3, (int[])nArray14, (int[])nArray2);
        SecP256K1Field.squareN((int[])nArray14, (int)2, (int[])nArray14, (int[])nArray2);
        int[] nArray15 = nArray3;
        SecP256K1Field.square((int[])nArray14, (int[])nArray15, (int[])nArray2);
        return Nat256.eq((int[])nArray, (int[])nArray15) ? new SecP256K1FieldElement(nArray14) : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecP256K1FieldElement)) {
            return false;
        }
        SecP256K1FieldElement secP256K1FieldElement = (SecP256K1FieldElement)object;
        return Nat256.eq((int[])this.x, (int[])secP256K1FieldElement.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 8);
    }
}

