/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperationError;
import com.azure.security.keyvault.administration.implementation.models.OperationStatus;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class RestoreOperation
implements JsonSerializable<RestoreOperation> {
    private OperationStatus status;
    private String statusDetails;
    private FullBackupOperationError error;
    private String jobId;
    private Long startTime;
    private Long endTime;

    private RestoreOperation() {
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public FullBackupOperationError getError() {
        return this.error;
    }

    public String getJobId() {
        return this.jobId;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startTime), ZoneOffset.UTC);
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.endTime), ZoneOffset.UTC);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeNumberField("startTime", (Number)this.startTime);
        jsonWriter.writeNumberField("endTime", (Number)this.endTime);
        return jsonWriter.writeEndObject();
    }

    public static RestoreOperation fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreOperation)jsonReader.readObject(reader -> {
            RestoreOperation deserializedRestoreOperation = new RestoreOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedRestoreOperation.status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedRestoreOperation.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedRestoreOperation.error = FullBackupOperationError.fromJson(reader);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedRestoreOperation.jobId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedRestoreOperation.startTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRestoreOperation.endTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreOperation;
        });
    }
}

