/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.security.keyvault.administration.implementation.models.Error;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationError;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;

public final class KeyVaultAdministrationUtils {
    private KeyVaultAdministrationUtils() {
        throw new UnsupportedOperationException("Cannot instantiate KeyVaultAdministrationUtils");
    }

    public static KeyVaultAdministrationException toKeyVaultAdministrationException(HttpResponseException exception) {
        if (exception == null) {
            return null;
        }
        return new KeyVaultAdministrationException(exception.getMessage(), exception.getResponse(), KeyVaultAdministrationUtils.toKeyVaultAdministrationError(exception.getValue()));
    }

    public static KeyVaultAdministrationError toKeyVaultAdministrationError(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Error) {
            Error error = (Error)value;
            return new KeyVaultAdministrationError(error.getCode(), error.getMessage(), KeyVaultAdministrationUtils.toKeyVaultAdministrationError(error.getInnerError()));
        }
        return new KeyVaultAdministrationError("ServiceError", value.toString(), null);
    }

    public static Throwable mapThrowableToKeyVaultAdministrationException(Throwable throwable) {
        if (throwable instanceof HttpResponseException) {
            return KeyVaultAdministrationUtils.toKeyVaultAdministrationException((HttpResponseException)throwable);
        }
        return throwable;
    }
}

