/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.io.IOException;

public final class Setting
implements JsonSerializable<Setting> {
    private final String name;
    private final String value;
    private KeyVaultSettingType type;

    private Setting(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public KeyVaultSettingType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Setting fromJson(JsonReader jsonReader) throws IOException {
        return (Setting)jsonReader.readObject(reader -> {
            String name = null;
            String value = null;
            KeyVaultSettingType type = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = KeyVaultSettingType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            Setting deserializedSetting = new Setting(name, value);
            deserializedSetting.type = type;
            return deserializedSetting;
        });
    }
}

