/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import java.io.IOException;

public final class SelectiveKeyRestoreOperationParameters
implements JsonSerializable<SelectiveKeyRestoreOperationParameters> {
    private final SASTokenParameter sasTokenParameters;
    private final String folder;

    public SelectiveKeyRestoreOperationParameters(SASTokenParameter sasTokenParameters, String folder) {
        this.sasTokenParameters = sasTokenParameters;
        this.folder = folder;
    }

    public SASTokenParameter getSasTokenParameters() {
        return this.sasTokenParameters;
    }

    public String getFolder() {
        return this.folder;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sasTokenParameters", (JsonSerializable)this.sasTokenParameters);
        jsonWriter.writeStringField("folder", this.folder);
        return jsonWriter.writeEndObject();
    }

    public static SelectiveKeyRestoreOperationParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SelectiveKeyRestoreOperationParameters)jsonReader.readObject(reader -> {
            SASTokenParameter sasTokenParameters = null;
            String folder = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sasTokenParameters".equals(fieldName)) {
                    sasTokenParameters = SASTokenParameter.fromJson(reader);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    folder = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new SelectiveKeyRestoreOperationParameters(sasTokenParameters, folder);
        });
    }
}

