/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.SASTokenParameter;
import java.io.IOException;

public final class RestoreOperationParameters
implements JsonSerializable<RestoreOperationParameters> {
    private final SASTokenParameter sasTokenParameters;
    private final String folderToRestore;

    public RestoreOperationParameters(SASTokenParameter sasTokenParameters, String folderToRestore) {
        this.sasTokenParameters = sasTokenParameters;
        this.folderToRestore = folderToRestore;
    }

    public SASTokenParameter getSasTokenParameters() {
        return this.sasTokenParameters;
    }

    public String getFolderToRestore() {
        return this.folderToRestore;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sasTokenParameters", (JsonSerializable)this.sasTokenParameters);
        jsonWriter.writeStringField("folderToRestore", this.folderToRestore);
        return jsonWriter.writeEndObject();
    }

    public static RestoreOperationParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreOperationParameters)jsonReader.readObject(reader -> {
            SASTokenParameter sasTokenParameters = null;
            String folderToRestore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sasTokenParameters".equals(fieldName)) {
                    sasTokenParameters = SASTokenParameter.fromJson(reader);
                    continue;
                }
                if ("folderToRestore".equals(fieldName)) {
                    folderToRestore = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new RestoreOperationParameters(sasTokenParameters, folderToRestore);
        });
    }
}

