/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.administration.implementation.models.FullBackupOperationError;
import com.azure.security.keyvault.administration.implementation.models.OperationStatus;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class FullBackupOperation
implements JsonSerializable<FullBackupOperation> {
    private OperationStatus status;
    private String statusDetails;
    private FullBackupOperationError error;
    private Long startTime;
    private Long endTime;
    private String jobId;
    private String azureStorageBlobContainerUri;

    private FullBackupOperation() {
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public FullBackupOperationError getError() {
        return this.error;
    }

    public OffsetDateTime getStartTime() {
        if (this.startTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.startTime), ZoneOffset.UTC);
    }

    public OffsetDateTime getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.endTime), ZoneOffset.UTC);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getAzureStorageBlobContainerUri() {
        return this.azureStorageBlobContainerUri;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("statusDetails", this.statusDetails);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeNumberField("startTime", (Number)this.startTime);
        jsonWriter.writeNumberField("endTime", (Number)this.endTime);
        jsonWriter.writeStringField("jobId", this.jobId);
        jsonWriter.writeStringField("azureStorageBlobContainerUri", this.azureStorageBlobContainerUri);
        return jsonWriter.writeEndObject();
    }

    public static FullBackupOperation fromJson(JsonReader jsonReader) throws IOException {
        return (FullBackupOperation)jsonReader.readObject(reader -> {
            FullBackupOperation deserializedFullBackupOperation = new FullBackupOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedFullBackupOperation.status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedFullBackupOperation.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedFullBackupOperation.error = FullBackupOperationError.fromJson(reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedFullBackupOperation.startTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedFullBackupOperation.endTime = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedFullBackupOperation.jobId = reader.getString();
                    continue;
                }
                if ("azureStorageBlobContainerUri".equals(fieldName)) {
                    deserializedFullBackupOperation.azureStorageBlobContainerUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFullBackupOperation;
        });
    }
}

