/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.administration.KeyVaultAdministrationUtil;
import com.azure.security.keyvault.administration.KeyVaultSettingsAsyncClient;
import com.azure.security.keyvault.administration.KeyVaultSettingsClientBuilder;
import com.azure.security.keyvault.administration.implementation.KeyVaultAdministrationClientImpl;
import com.azure.security.keyvault.administration.implementation.models.Setting;
import com.azure.security.keyvault.administration.implementation.models.SettingsListResult;
import com.azure.security.keyvault.administration.implementation.models.UpdateSettingRequest;
import com.azure.security.keyvault.administration.models.KeyVaultGetSettingsResult;
import com.azure.security.keyvault.administration.models.KeyVaultSetting;
import com.azure.security.keyvault.administration.models.KeyVaultSettingType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=KeyVaultSettingsClientBuilder.class)
public final class KeyVaultSettingsClient {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSettingsClient.class);
    private final KeyVaultAdministrationClientImpl implClient;

    KeyVaultSettingsClient(KeyVaultAdministrationClientImpl implClient) {
        this.implClient = implClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSetting updateSetting(KeyVaultSetting setting) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            return KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)this.implClient.updateSettingWithResponse(setting.getName(), BinaryData.fromObject((Object)new UpdateSettingRequest(settingValue)), KeyVaultAdministrationUtil.EMPTY_OPTIONS).getValue()).toObject(Setting.class));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSetting> updateSettingWithResponse(KeyVaultSetting setting, Context context) {
        Objects.requireNonNull(setting, String.format("%s cannot be null.", "'setting'"));
        try {
            String settingValue = null;
            if (setting.getType() == KeyVaultSettingType.BOOLEAN) {
                settingValue = Boolean.toString(setting.asBoolean());
            }
            Response<BinaryData> response = this.implClient.updateSettingWithResponse(setting.getName(), BinaryData.fromObject((Object)new UpdateSettingRequest(settingValue)), new RequestOptions().setContext(context));
            return new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultSetting getSetting(String name) {
        try {
            return KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)this.implClient.getSettingWithResponse(name, KeyVaultAdministrationUtil.EMPTY_OPTIONS).getValue()).toObject(Setting.class));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultSetting> getSettingWithResponse(String name, Context context) {
        try {
            Response<BinaryData> response = this.implClient.getSettingWithResponse(name, new RequestOptions().setContext(context));
            return new SimpleResponse(response, (Object)KeyVaultSettingsAsyncClient.transformToKeyVaultSetting((Setting)((BinaryData)response.getValue()).toObject(Setting.class)));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVaultGetSettingsResult getSettings() {
        try {
            List<KeyVaultSetting> keyVaultSettings = ((SettingsListResult)((BinaryData)this.implClient.getSettingsWithResponse(KeyVaultAdministrationUtil.EMPTY_OPTIONS).getValue()).toObject(SettingsListResult.class)).getSettings().stream().map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting).collect(Collectors.toList());
            return new KeyVaultGetSettingsResult(keyVaultSettings);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVaultGetSettingsResult> getSettingsWithResponse(Context context) {
        try {
            Response<BinaryData> response = this.implClient.getSettingsWithResponse(new RequestOptions().setContext(context));
            List<KeyVaultSetting> keyVaultSettings = ((SettingsListResult)((BinaryData)response.getValue()).toObject(SettingsListResult.class)).getSettings().stream().map(KeyVaultSettingsAsyncClient::transformToKeyVaultSetting).collect(Collectors.toList());
            return new SimpleResponse(response, (Object)new KeyVaultGetSettingsResult(keyVaultSettings));
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }
}

