/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mixedreality.authentication;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AccessToken;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.mixedreality.authentication.CorrelationVector;
import com.azure.mixedreality.authentication.JsonWebToken;
import com.azure.mixedreality.authentication.MixedRealityStsClientBuilder;
import com.azure.mixedreality.authentication.implementation.MixedRealityStsRestClientImpl;
import com.azure.mixedreality.authentication.implementation.models.GetTokenHeaders;
import com.azure.mixedreality.authentication.implementation.models.StsTokenResponseMessage;
import com.azure.mixedreality.authentication.implementation.models.TokenRequestOptions;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

@ServiceClient(builder=MixedRealityStsClientBuilder.class, isAsync=true)
public final class MixedRealityStsAsyncClient {
    private static final String MIXED_REALITY_TRACING_NAMESPACE_VALUE = "Microsoft.MixedReality";
    private final UUID accountId;
    private final ClientLogger logger = new ClientLogger(MixedRealityStsAsyncClient.class);
    private final MixedRealityStsRestClientImpl serviceClient;

    MixedRealityStsAsyncClient(UUID accountId, MixedRealityStsRestClientImpl serviceClient) {
        this.accountId = accountId;
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessToken> getToken() {
        try {
            return this.getTokenWithResponse().map(response -> (AccessToken)response.getValue());
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AccessToken>> getTokenWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.getTokenWithResponse((Context)context));
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    Mono<Response<AccessToken>> getTokenWithResponse(Context context) {
        try {
            TokenRequestOptions requestOptions = new TokenRequestOptions();
            requestOptions.setClientRequestId(CorrelationVector.generateCvBase());
            return this.serviceClient.getTokenWithResponseAsync(this.accountId, requestOptions, context.addData((Object)"az.namespace", (Object)MIXED_REALITY_TRACING_NAMESPACE_VALUE)).map(originalResponse -> {
                AccessToken accessToken = MixedRealityStsAsyncClient.toAccessToken(originalResponse.getValue());
                return new ResponseBase(originalResponse.getRequest(), originalResponse.getStatusCode(), originalResponse.getHeaders(), (Object)accessToken, (Object)((GetTokenHeaders)originalResponse.getDeserializedHeaders()));
            });
        }
        catch (RuntimeException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
    }

    private static AccessToken toAccessToken(StsTokenResponseMessage stsTokenResponseMessage) {
        String accessToken = stsTokenResponseMessage.getAccessToken();
        OffsetDateTime tokenExpiration = JsonWebToken.retrieveExpiration(accessToken);
        return new AccessToken(accessToken, tokenExpiration);
    }
}

