/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.CoreUtils;
import java.net.URL;
import reactor.core.publisher.Mono;

final class ReverseProxyPolicy
implements HttpPipelinePolicy {
    private final String reverseProxyEndpoint;

    ReverseProxyPolicy(String reverseProxyEndpoint) {
        this.reverseProxyEndpoint = reverseProxyEndpoint;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String query;
        URL url = context.getHttpRequest().getUrl();
        String reverseProxyUrl = this.reverseProxyEndpoint;
        String path = url.getPath();
        if (!CoreUtils.isNullOrEmpty((CharSequence)path)) {
            reverseProxyUrl = reverseProxyUrl + path;
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(query = url.getQuery()))) {
            reverseProxyUrl = reverseProxyUrl + "?" + query;
        }
        HttpRequest requestCopy = context.getHttpRequest().copy();
        context.setHttpRequest(requestCopy.setUrl(reverseProxyUrl));
        return next.clone().process();
    }
}

