/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.messaging.webpubsub.models.WebPubSubClientAccessToken;
import java.io.IOException;

public final class WebPubSubUtil {
    private static final ClientLogger LOGGER = new ClientLogger(WebPubSubUtil.class);
    private static final String TOKEN = "token";

    public static String getToken(BinaryData binaryData) {
        String string;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)binaryData.toString());
            try {
                string = (String)jsonReader.readObject(reader -> {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if (!TOKEN.equals(fieldName)) continue;
                        return reader.getString();
                    }
                    return null;
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.logThrowableAsError((Throwable)new IllegalStateException("Unable to find token in the response", e));
                    return null;
                }
            }
            jsonReader.close();
        }
        return string;
    }

    public static WebPubSubClientAccessToken createToken(String token, String endpoint, String hub, String path) {
        endpoint = endpoint.endsWith("/") ? endpoint : endpoint + "/";
        String clientEndpoint = endpoint.replaceFirst("http", "ws");
        String clientUrl = clientEndpoint + path + hub;
        String url = clientUrl + "?access_token=" + token;
        return new WebPubSubClientAccessToken(token, url);
    }

    private WebPubSubUtil() {
    }
}

