/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.util.BinaryData;
import com.azure.messaging.webpubsub.client.WebPubSubAsyncClient;
import com.azure.messaging.webpubsub.client.WebPubSubClientBuilder;
import com.azure.messaging.webpubsub.client.implementation.EventHandlerCollection;
import com.azure.messaging.webpubsub.client.implementation.WebPubSubClientState;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketSession;
import com.azure.messaging.webpubsub.client.models.ConnectedEvent;
import com.azure.messaging.webpubsub.client.models.DisconnectedEvent;
import com.azure.messaging.webpubsub.client.models.GroupMessageEvent;
import com.azure.messaging.webpubsub.client.models.RejoinGroupFailedEvent;
import com.azure.messaging.webpubsub.client.models.SendEventOptions;
import com.azure.messaging.webpubsub.client.models.SendToGroupOptions;
import com.azure.messaging.webpubsub.client.models.ServerMessageEvent;
import com.azure.messaging.webpubsub.client.models.StoppedEvent;
import com.azure.messaging.webpubsub.client.models.WebPubSubDataFormat;
import com.azure.messaging.webpubsub.client.models.WebPubSubResult;
import java.io.Closeable;
import java.util.function.Consumer;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=WebPubSubClientBuilder.class)
public final class WebPubSubClient
implements Closeable {
    private final WebPubSubAsyncClient asyncClient;
    private final EventHandlerCollection eventHandlerCollection = new EventHandlerCollection();
    private static final String GROUP_MESSAGE_EVENT = "GroupMessageEvent";
    private static final String SERVER_MESSAGE_EVENT = "ServerMessageEvent";
    private static final String CONNECT_EVENT = "ConnectedEvent";
    private static final String DISCONNECT_EVENT = "DisconnectedEvent";
    private static final String STOPPED_EVENT = "StoppedEvent";
    private static final String REJOIN_GROUP_FAILED_EVENT = "RejoinGroupFailedEvent";

    WebPubSubClient(WebPubSubAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public String getConnectionId() {
        return this.asyncClient.getConnectionId();
    }

    public synchronized void start() {
        this.asyncClient.start(() -> {
            this.asyncClient.receiveGroupMessageEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(GROUP_MESSAGE_EVENT, event));
            this.asyncClient.receiveServerMessageEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(SERVER_MESSAGE_EVENT, event));
            this.asyncClient.receiveConnectedEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(CONNECT_EVENT, event));
            this.asyncClient.receiveDisconnectedEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(DISCONNECT_EVENT, event));
            this.asyncClient.receiveStoppedEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(STOPPED_EVENT, event));
            this.asyncClient.receiveRejoinGroupFailedEvents().publishOn(Schedulers.boundedElastic()).subscribe(event -> this.eventHandlerCollection.fireEvent(REJOIN_GROUP_FAILED_EVENT, event));
        }).block();
    }

    public synchronized void stop() {
        this.asyncClient.stop().block();
    }

    @Override
    public void close() {
        this.stop();
    }

    public void addOnGroupMessageEventHandler(Consumer<GroupMessageEvent> onGroupMessageEventHandler) {
        this.eventHandlerCollection.addEventHandler(GROUP_MESSAGE_EVENT, onGroupMessageEventHandler);
    }

    public void removeOnGroupMessageEventHandler(Consumer<GroupMessageEvent> onGroupMessageEventHandler) {
        this.eventHandlerCollection.removeEventHandler(GROUP_MESSAGE_EVENT, onGroupMessageEventHandler);
    }

    public void addOnServerMessageEventHandler(Consumer<ServerMessageEvent> onServiceMessageEventHandler) {
        this.eventHandlerCollection.addEventHandler(SERVER_MESSAGE_EVENT, onServiceMessageEventHandler);
    }

    public void removeOnServerMessageEventHandler(Consumer<ServerMessageEvent> onServiceMessageEventHandler) {
        this.eventHandlerCollection.removeEventHandler(SERVER_MESSAGE_EVENT, onServiceMessageEventHandler);
    }

    public void addOnConnectedEventHandler(Consumer<ConnectedEvent> onConnectedEventHandler) {
        this.eventHandlerCollection.addEventHandler(CONNECT_EVENT, onConnectedEventHandler);
    }

    public void removeOnConnectedEventHandler(Consumer<ConnectedEvent> onConnectedEventHandler) {
        this.eventHandlerCollection.removeEventHandler(CONNECT_EVENT, onConnectedEventHandler);
    }

    public void addOnDisconnectedEventHandler(Consumer<DisconnectedEvent> onDisconnectedEventHandler) {
        this.eventHandlerCollection.addEventHandler(DISCONNECT_EVENT, onDisconnectedEventHandler);
    }

    public void removeOnDisconnectedEventHandler(Consumer<DisconnectedEvent> onDisconnectedEventHandler) {
        this.eventHandlerCollection.removeEventHandler(DISCONNECT_EVENT, onDisconnectedEventHandler);
    }

    public void addOnStoppedEventHandler(Consumer<StoppedEvent> onStoppedEventHandler) {
        this.eventHandlerCollection.addEventHandler(STOPPED_EVENT, onStoppedEventHandler);
    }

    public void removeOnStoppedEventHandler(Consumer<StoppedEvent> onStoppedEventHandler) {
        this.eventHandlerCollection.removeEventHandler(STOPPED_EVENT, onStoppedEventHandler);
    }

    public void addOnRejoinGroupFailedEventHandler(Consumer<RejoinGroupFailedEvent> onRejoinGroupFailedEventHandler) {
        this.eventHandlerCollection.addEventHandler(REJOIN_GROUP_FAILED_EVENT, onRejoinGroupFailedEventHandler);
    }

    public void removeOnRejoinGroupFailedEventHandler(Consumer<RejoinGroupFailedEvent> onRejoinGroupFailedEventHandler) {
        this.eventHandlerCollection.removeEventHandler(REJOIN_GROUP_FAILED_EVENT, onRejoinGroupFailedEventHandler);
    }

    public WebPubSubResult joinGroup(String group) {
        return (WebPubSubResult)this.asyncClient.joinGroup(group).block();
    }

    public WebPubSubResult joinGroup(String group, Long ackId) {
        return (WebPubSubResult)this.asyncClient.joinGroup(group, ackId).block();
    }

    public WebPubSubResult leaveGroup(String group) {
        return (WebPubSubResult)this.asyncClient.leaveGroup(group).block();
    }

    public WebPubSubResult leaveGroup(String group, Long ackId) {
        return (WebPubSubResult)this.asyncClient.leaveGroup(group, ackId).block();
    }

    public WebPubSubResult sendToGroup(String group, String content) {
        return this.sendToGroup(group, BinaryData.fromString((String)content), WebPubSubDataFormat.TEXT);
    }

    public WebPubSubResult sendToGroup(String group, String content, SendToGroupOptions options) {
        return this.sendToGroup(group, BinaryData.fromString((String)content), WebPubSubDataFormat.TEXT, options);
    }

    public WebPubSubResult sendToGroup(String group, BinaryData content, WebPubSubDataFormat dataFormat) {
        return (WebPubSubResult)this.asyncClient.sendToGroup(group, content, dataFormat).block();
    }

    public WebPubSubResult sendToGroup(String group, BinaryData content, WebPubSubDataFormat dataFormat, SendToGroupOptions options) {
        return (WebPubSubResult)this.asyncClient.sendToGroup(group, content, dataFormat, options).block();
    }

    public WebPubSubResult sendEvent(String eventName, BinaryData content, WebPubSubDataFormat dataFormat) {
        return (WebPubSubResult)this.asyncClient.sendEvent(eventName, content, dataFormat).block();
    }

    public WebPubSubResult sendEvent(String eventName, BinaryData content, WebPubSubDataFormat dataFormat, SendEventOptions options) {
        return (WebPubSubResult)this.asyncClient.sendEvent(eventName, content, dataFormat, options).block();
    }

    WebPubSubClientState getClientState() {
        return this.asyncClient.getClientState();
    }

    WebSocketSession getWebsocketSession() {
        return this.asyncClient.getWebsocketSession();
    }
}

