/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.namespaces.models.FailedLockToken;
import java.io.IOException;
import java.util.List;

public final class RejectResult
implements JsonSerializable<RejectResult> {
    private final List<FailedLockToken> failedLockTokens;
    private final List<String> succeededLockTokens;

    private RejectResult(List<FailedLockToken> failedLockTokens, List<String> succeededLockTokens) {
        this.failedLockTokens = failedLockTokens;
        this.succeededLockTokens = succeededLockTokens;
    }

    public List<FailedLockToken> getFailedLockTokens() {
        return this.failedLockTokens;
    }

    public List<String> getSucceededLockTokens() {
        return this.succeededLockTokens;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("failedLockTokens", this.failedLockTokens, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("succeededLockTokens", this.succeededLockTokens, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RejectResult fromJson(JsonReader jsonReader) throws IOException {
        return (RejectResult)jsonReader.readObject(reader -> {
            List failedLockTokens = null;
            List succeededLockTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("failedLockTokens".equals(fieldName)) {
                    failedLockTokens = reader.readArray(reader1 -> FailedLockToken.fromJson(reader1));
                    continue;
                }
                if ("succeededLockTokens".equals(fieldName)) {
                    succeededLockTokens = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new RejectResult(failedLockTokens, succeededLockTokens);
        });
    }
}

