/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class BrokerProperties
implements JsonSerializable<BrokerProperties> {
    private final String lockToken;
    private final int deliveryCount;

    private BrokerProperties(String lockToken, int deliveryCount) {
        this.lockToken = lockToken;
        this.deliveryCount = deliveryCount;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lockToken", this.lockToken);
        jsonWriter.writeIntField("deliveryCount", this.deliveryCount);
        return jsonWriter.writeEndObject();
    }

    public static BrokerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BrokerProperties)jsonReader.readObject(reader -> {
            String lockToken = null;
            int deliveryCount = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lockToken".equals(fieldName)) {
                    lockToken = reader.getString();
                    continue;
                }
                if ("deliveryCount".equals(fieldName)) {
                    deliveryCount = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new BrokerProperties(lockToken, deliveryCount);
        });
    }
}

