/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate.implementation;

import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.net.URI;
import java.net.URISyntaxException;
import reactor.core.publisher.Mono;

public final class PollingUtils {
    public static Mono<BinaryData> serializeResponse(Object response, ObjectSerializer serializer) {
        if (response instanceof BinaryData) {
            return Mono.just((Object)((BinaryData)response));
        }
        return BinaryData.fromObjectAsync((Object)response, (ObjectSerializer)serializer);
    }

    public static <T> Mono<T> deserializeResponse(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (typeReference.getJavaClass().isAssignableFrom(BinaryData.class)) {
            return Mono.just((Object)binaryData);
        }
        return binaryData.toObjectAsync(typeReference, serializer);
    }

    public static <T> Mono<T> convertResponse(Object response, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (response == null) {
            return Mono.empty();
        }
        if (typeReference.getJavaClass().isAssignableFrom(BinaryData.class)) {
            return Mono.just((Object)response);
        }
        return PollingUtils.serializeResponse(response, serializer).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, serializer, typeReference));
    }

    public static String getAbsolutePath(String path, String endpoint, ClientLogger logger) {
        try {
            URI uri = new URI(path);
            if (!uri.isAbsolute()) {
                if (CoreUtils.isNullOrEmpty((CharSequence)endpoint)) {
                    throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Relative path requires endpoint to be non-null or non-empty to create an absolute path."));
                }
                return endpoint + path;
            }
        }
        catch (URISyntaxException ex) {
            throw logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'path' must be a valid URI.", ex));
        }
        return path;
    }

    private PollingUtils() {
    }
}

