/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate.implementation;

import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.OperationResourcePollingStrategy;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.iot.deviceupdate.implementation.DefaultJsonSerializer;
import com.azure.iot.deviceupdate.implementation.PollingUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class OperationResourcePollingStrategyWithEndpoint<T, U>
extends OperationResourcePollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(OperationResourcePollingStrategy.class);
    private final String endpoint;
    private final String operationLocationHeaderName;
    private final ObjectSerializer serializer;
    private final HttpPipeline httpPipeline;
    private final Context context;

    public OperationResourcePollingStrategyWithEndpoint(HttpPipeline httpPipeline, String endpoint, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        super(httpPipeline, endpoint, serializer, operationLocationHeaderName, context);
        this.operationLocationHeaderName = operationLocationHeaderName != null ? operationLocationHeaderName : "Operation-Location";
        this.endpoint = endpoint;
        this.serializer = serializer != null ? serializer : new DefaultJsonSerializer();
        this.httpPipeline = Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null");
        this.context = context == null ? Context.NONE : context;
    }

    public Mono<Boolean> canPoll(Response<?> initialResponse) {
        HttpHeader operationLocationHeader = initialResponse.getHeaders().get(this.operationLocationHeaderName);
        if (operationLocationHeader != null) {
            try {
                new URL(PollingUtils.getAbsolutePath(operationLocationHeader.getValue(), this.endpoint, LOGGER));
                return Mono.just((Object)true);
            }
            catch (MalformedURLException e) {
                return Mono.just((Object)false);
            }
        }
        return Mono.just((Object)false);
    }

    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader locationHeader = response.getHeaders().get("Location");
        if (operationLocationHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName, PollingUtils.getAbsolutePath(operationLocationHeader.getValue(), this.endpoint, LOGGER));
        }
        if (locationHeader != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(locationHeader.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            String retryAfterValue = response.getHeaders().getValue("Retry-After");
            Duration retryAfter = retryAfterValue == null ? null : Duration.ofSeconds(Long.parseLong(retryAfterValue));
            return PollingUtils.convertResponse(response.getValue(), this.serializer, pollResponseType).map(value -> new PollResponse(LongRunningOperationStatus.IN_PROGRESS, value, retryAfter)).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse(LongRunningOperationStatus.IN_PROGRESS, null, retryAfter)));
        }
        return Mono.error((Throwable)new AzureException(String.format("Operation failed or cancelled with status code %d,, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, operationLocationHeader, PollingUtils.serializeResponse(response.getValue(), this.serializer))));
    }

    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            return Mono.error((Throwable)new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            return Mono.error((Throwable)new AzureException("Long running operation cancelled."));
        }
        String finalGetUrl = PollingUtils.getAbsolutePath(pollingContext.getData("resourceLocation"), this.endpoint, LOGGER);
        if (finalGetUrl == null) {
            String httpMethod = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod) && pollingContext.getData("Location") != null) {
                finalGetUrl = pollingContext.getData("Location");
            } else {
                return Mono.error((Throwable)new AzureException("Cannot get final result"));
            }
        }
        if (finalGetUrl == null) {
            String latestResponseBody = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponse(BinaryData.fromString((String)latestResponseBody), this.serializer, resultType);
        }
        HttpRequest request = new HttpRequest(HttpMethod.GET, finalGetUrl);
        return FluxUtil.withContext(context1 -> this.httpPipeline.send(request, CoreUtils.mergeContexts((Context)context1, (Context)this.context))).flatMap(HttpResponse::getBodyAsByteArray).map(BinaryData::fromBytes).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, this.serializer, resultType));
    }
}

