/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.SecretType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class TestSecret
implements JsonSerializable<TestSecret> {
    private String value;
    private SecretType type;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getValue() {
        return this.value;
    }

    public TestSecret setValue(String value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    public SecretType getType() {
        return this.type;
    }

    public TestSecret setType(SecretType type) {
        this.type = type;
        this.updatedProperties.add("type");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("value")) {
            if (this.value == null) {
                jsonWriter.writeNullField("value");
            } else {
                jsonWriter.writeStringField("value", this.value);
            }
        }
        if (this.updatedProperties.contains("type")) {
            if (this.type == null) {
                jsonWriter.writeNullField("type");
            } else {
                jsonWriter.writeStringField("type", this.type.toString());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestSecret fromJson(JsonReader jsonReader) throws IOException {
        return (TestSecret)jsonReader.readObject(reader -> {
            TestSecret deserializedTestSecret = new TestSecret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedTestSecret.value = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTestSecret.type = SecretType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestSecret;
        });
    }

    static {
        JsonMergePatchHelper.setTestSecretAccessor(new JsonMergePatchHelper.TestSecretAccessor(){

            @Override
            public TestSecret prepareModelForJsonMergePatch(TestSecret model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestSecret model) {
                return model.jsonMergePatch;
            }
        });
    }
}

