/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.TargetResourceConfigurations;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;

public final class TestProfile
implements JsonSerializable<TestProfile> {
    private String testProfileId;
    private String displayName;
    private String description;
    private String testId;
    private String targetResourceId;
    private TargetResourceConfigurations targetResourceConfigurations;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getTestProfileId() {
        return this.testProfileId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TestProfile setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public TestProfile setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public String getTestId() {
        return this.testId;
    }

    public TestProfile setTestId(String testId) {
        this.testId = testId;
        this.updatedProperties.add("testId");
        return this;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public TestProfile setTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        this.updatedProperties.add("targetResourceId");
        return this;
    }

    public TargetResourceConfigurations getTargetResourceConfigurations() {
        return this.targetResourceConfigurations;
    }

    public TestProfile setTargetResourceConfigurations(TargetResourceConfigurations targetResourceConfigurations) {
        this.targetResourceConfigurations = targetResourceConfigurations;
        this.updatedProperties.add("targetResourceConfigurations");
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("testId", this.testId);
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeJsonField("targetResourceConfigurations", (JsonSerializable)this.targetResourceConfigurations);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("testId")) {
            if (this.testId == null) {
                jsonWriter.writeNullField("testId");
            } else {
                jsonWriter.writeStringField("testId", this.testId);
            }
        }
        if (this.updatedProperties.contains("targetResourceId")) {
            if (this.targetResourceId == null) {
                jsonWriter.writeNullField("targetResourceId");
            } else {
                jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
            }
        }
        if (this.updatedProperties.contains("targetResourceConfigurations")) {
            if (this.targetResourceConfigurations == null) {
                jsonWriter.writeNullField("targetResourceConfigurations");
            } else {
                JsonMergePatchHelper.getTargetResourceConfigurationsAccessor().prepareModelForJsonMergePatch(this.targetResourceConfigurations, true);
                jsonWriter.writeJsonField("targetResourceConfigurations", (JsonSerializable)this.targetResourceConfigurations);
                JsonMergePatchHelper.getTargetResourceConfigurationsAccessor().prepareModelForJsonMergePatch(this.targetResourceConfigurations, false);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestProfile fromJson(JsonReader jsonReader) throws IOException {
        return (TestProfile)jsonReader.readObject(reader -> {
            TestProfile deserializedTestProfile = new TestProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("testProfileId".equals(fieldName)) {
                    deserializedTestProfile.testProfileId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedTestProfile.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTestProfile.description = reader.getString();
                    continue;
                }
                if ("testId".equals(fieldName)) {
                    deserializedTestProfile.testId = reader.getString();
                    continue;
                }
                if ("targetResourceId".equals(fieldName)) {
                    deserializedTestProfile.targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceConfigurations".equals(fieldName)) {
                    deserializedTestProfile.targetResourceConfigurations = TargetResourceConfigurations.fromJson(reader);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTestProfile.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedTestProfile.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedTestProfile.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedTestProfile.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestProfile;
        });
    }

    static {
        JsonMergePatchHelper.setTestProfileAccessor(new JsonMergePatchHelper.TestProfileAccessor(){

            @Override
            public TestProfile prepareModelForJsonMergePatch(TestProfile model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestProfile model) {
                return model.jsonMergePatch;
            }
        });
    }
}

