/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class ResourceMetric
implements JsonSerializable<ResourceMetric> {
    private String id;
    private String resourceId;
    private String metricNamespace;
    private String displayDescription;
    private String name;
    private String aggregation;
    private String unit;
    private String resourceType;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ResourceMetric setResourceId(String resourceId) {
        this.resourceId = resourceId;
        this.updatedProperties.add("resourceId");
        return this;
    }

    public String getMetricNamespace() {
        return this.metricNamespace;
    }

    public ResourceMetric setMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        this.updatedProperties.add("metricNamespace");
        return this;
    }

    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public ResourceMetric setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        this.updatedProperties.add("displayDescription");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ResourceMetric setName(String name) {
        this.name = name;
        this.updatedProperties.add("name");
        return this;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public ResourceMetric setAggregation(String aggregation) {
        this.aggregation = aggregation;
        this.updatedProperties.add("aggregation");
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public ResourceMetric setUnit(String unit) {
        this.unit = unit;
        this.updatedProperties.add("unit");
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceMetric setResourceType(String resourceType) {
        this.resourceType = resourceType;
        this.updatedProperties.add("resourceType");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("aggregation", this.aggregation);
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("resourceId")) {
            if (this.resourceId == null) {
                jsonWriter.writeNullField("resourceId");
            } else {
                jsonWriter.writeStringField("resourceId", this.resourceId);
            }
        }
        if (this.updatedProperties.contains("metricNamespace")) {
            if (this.metricNamespace == null) {
                jsonWriter.writeNullField("metricNamespace");
            } else {
                jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
            }
        }
        if (this.updatedProperties.contains("displayDescription")) {
            if (this.displayDescription == null) {
                jsonWriter.writeNullField("displayDescription");
            } else {
                jsonWriter.writeStringField("displayDescription", this.displayDescription);
            }
        }
        if (this.updatedProperties.contains("name")) {
            if (this.name == null) {
                jsonWriter.writeNullField("name");
            } else {
                jsonWriter.writeStringField("name", this.name);
            }
        }
        if (this.updatedProperties.contains("aggregation")) {
            if (this.aggregation == null) {
                jsonWriter.writeNullField("aggregation");
            } else {
                jsonWriter.writeStringField("aggregation", this.aggregation);
            }
        }
        if (this.updatedProperties.contains("unit")) {
            if (this.unit == null) {
                jsonWriter.writeNullField("unit");
            } else {
                jsonWriter.writeStringField("unit", this.unit);
            }
        }
        if (this.updatedProperties.contains("resourceType")) {
            if (this.resourceType == null) {
                jsonWriter.writeNullField("resourceType");
            } else {
                jsonWriter.writeStringField("resourceType", this.resourceType);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ResourceMetric fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceMetric)jsonReader.readObject(reader -> {
            ResourceMetric deserializedResourceMetric = new ResourceMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedResourceMetric.id = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceMetric.resourceId = reader.getString();
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedResourceMetric.metricNamespace = reader.getString();
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedResourceMetric.displayDescription = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceMetric.name = reader.getString();
                    continue;
                }
                if ("aggregation".equals(fieldName)) {
                    deserializedResourceMetric.aggregation = reader.getString();
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedResourceMetric.unit = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceMetric.resourceType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceMetric;
        });
    }

    static {
        JsonMergePatchHelper.setResourceMetricAccessor(new JsonMergePatchHelper.ResourceMetricAccessor(){

            @Override
            public ResourceMetric prepareModelForJsonMergePatch(ResourceMetric model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(ResourceMetric model) {
                return model.jsonMergePatch;
            }
        });
    }
}

