/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.PassFailAction;
import com.azure.developer.loadtesting.models.PassFailAggregationFunction;
import com.azure.developer.loadtesting.models.PassFailResult;
import com.azure.developer.loadtesting.models.PfMetrics;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class PassFailMetric
implements JsonSerializable<PassFailMetric> {
    private PfMetrics clientMetric;
    private PassFailAggregationFunction aggregate;
    private String condition;
    private String requestName;
    private Double value;
    private PassFailAction action;
    private Double actualValue;
    private PassFailResult result;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public PfMetrics getClientMetric() {
        return this.clientMetric;
    }

    public PassFailAggregationFunction getAggregate() {
        return this.aggregate;
    }

    public String getCondition() {
        return this.condition;
    }

    public PassFailMetric setCondition(String condition) {
        this.condition = condition;
        this.updatedProperties.add("condition");
        return this;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public PassFailMetric setRequestName(String requestName) {
        this.requestName = requestName;
        this.updatedProperties.add("requestName");
        return this;
    }

    public Double getValue() {
        return this.value;
    }

    public PassFailMetric setValue(Double value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    public PassFailAction getAction() {
        return this.action;
    }

    public Double getActualValue() {
        return this.actualValue;
    }

    public PassFailResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientMetric", this.clientMetric == null ? null : this.clientMetric.toString());
        jsonWriter.writeStringField("aggregate", this.aggregate == null ? null : this.aggregate.toString());
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("requestName", this.requestName);
        jsonWriter.writeNumberField("value", (Number)this.value);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("clientMetric")) {
            if (this.clientMetric == null) {
                jsonWriter.writeNullField("clientMetric");
            } else {
                jsonWriter.writeStringField("clientMetric", this.clientMetric.toString());
            }
        }
        if (this.updatedProperties.contains("aggregate")) {
            if (this.aggregate == null) {
                jsonWriter.writeNullField("aggregate");
            } else {
                jsonWriter.writeStringField("aggregate", this.aggregate.toString());
            }
        }
        if (this.updatedProperties.contains("condition")) {
            if (this.condition == null) {
                jsonWriter.writeNullField("condition");
            } else {
                jsonWriter.writeStringField("condition", this.condition);
            }
        }
        if (this.updatedProperties.contains("requestName")) {
            if (this.requestName == null) {
                jsonWriter.writeNullField("requestName");
            } else {
                jsonWriter.writeStringField("requestName", this.requestName);
            }
        }
        if (this.updatedProperties.contains("value")) {
            if (this.value == null) {
                jsonWriter.writeNullField("value");
            } else {
                jsonWriter.writeNumberField("value", (Number)this.value);
            }
        }
        if (this.updatedProperties.contains("action")) {
            if (this.action == null) {
                jsonWriter.writeNullField("action");
            } else {
                jsonWriter.writeStringField("action", this.action.toString());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PassFailMetric fromJson(JsonReader jsonReader) throws IOException {
        return (PassFailMetric)jsonReader.readObject(reader -> {
            PassFailMetric deserializedPassFailMetric = new PassFailMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientMetric".equals(fieldName)) {
                    deserializedPassFailMetric.clientMetric = PfMetrics.fromString(reader.getString());
                    continue;
                }
                if ("aggregate".equals(fieldName)) {
                    deserializedPassFailMetric.aggregate = PassFailAggregationFunction.fromString(reader.getString());
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedPassFailMetric.condition = reader.getString();
                    continue;
                }
                if ("requestName".equals(fieldName)) {
                    deserializedPassFailMetric.requestName = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedPassFailMetric.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedPassFailMetric.action = PassFailAction.fromString(reader.getString());
                    continue;
                }
                if ("actualValue".equals(fieldName)) {
                    deserializedPassFailMetric.actualValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    deserializedPassFailMetric.result = PassFailResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPassFailMetric;
        });
    }

    public PassFailMetric setAggregate(PassFailAggregationFunction aggregate) {
        this.aggregate = aggregate;
        this.updatedProperties.add("aggregate");
        return this;
    }

    public PassFailMetric setAction(PassFailAction action) {
        this.action = action;
        this.updatedProperties.add("action");
        return this;
    }

    public PassFailMetric setClientMetric(PfMetrics clientMetric) {
        this.clientMetric = clientMetric;
        this.updatedProperties.add("clientMetric");
        return this;
    }

    static {
        JsonMergePatchHelper.setPassFailMetricAccessor(new JsonMergePatchHelper.PassFailMetricAccessor(){

            @Override
            public PassFailMetric prepareModelForJsonMergePatch(PassFailMetric model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(PassFailMetric model) {
                return model.jsonMergePatch;
            }
        });
    }
}

