/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class LoadTestingAppComponent
implements JsonSerializable<LoadTestingAppComponent> {
    private String resourceId;
    private String resourceName;
    private String resourceType;
    private String displayName;
    private String resourceGroup;
    private String subscriptionId;
    private String kind;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public LoadTestingAppComponent setResourceName(String resourceName) {
        this.resourceName = resourceName;
        this.updatedProperties.add("resourceName");
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public LoadTestingAppComponent setResourceType(String resourceType) {
        this.resourceType = resourceType;
        this.updatedProperties.add("resourceType");
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LoadTestingAppComponent setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getKind() {
        return this.kind;
    }

    public LoadTestingAppComponent setKind(String kind) {
        this.kind = kind;
        this.updatedProperties.add("kind");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("resourceName")) {
            if (this.resourceName == null) {
                jsonWriter.writeNullField("resourceName");
            } else {
                jsonWriter.writeStringField("resourceName", this.resourceName);
            }
        }
        if (this.updatedProperties.contains("resourceType")) {
            if (this.resourceType == null) {
                jsonWriter.writeNullField("resourceType");
            } else {
                jsonWriter.writeStringField("resourceType", this.resourceType);
            }
        }
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("kind")) {
            if (this.kind == null) {
                jsonWriter.writeNullField("kind");
            } else {
                jsonWriter.writeStringField("kind", this.kind);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LoadTestingAppComponent fromJson(JsonReader jsonReader) throws IOException {
        return (LoadTestingAppComponent)jsonReader.readObject(reader -> {
            LoadTestingAppComponent deserializedLoadTestingAppComponent = new LoadTestingAppComponent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.resourceId = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.resourceName = reader.getString();
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.resourceType = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.displayName = reader.getString();
                    continue;
                }
                if ("resourceGroup".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.resourceGroup = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.subscriptionId = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedLoadTestingAppComponent.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadTestingAppComponent;
        });
    }

    static {
        JsonMergePatchHelper.setLoadTestingAppComponentAccessor(new JsonMergePatchHelper.LoadTestingAppComponentAccessor(){

            @Override
            public LoadTestingAppComponent prepareModelForJsonMergePatch(LoadTestingAppComponent model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(LoadTestingAppComponent model) {
                return model.jsonMergePatch;
            }
        });
    }
}

