/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.loadtesting.LoadTestRunClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.LoadTestRunsImpl;
import java.time.Duration;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LoadTestRunClientBuilder.class, isAsync=true)
public final class LoadTestRunAsyncClient {
    private final LoadTestRunsImpl serviceClient;

    LoadTestRunAsyncClient(LoadTestRunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginTestRun(String testRunId, BinaryData body, RequestOptions testRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testRunRequestOptions != null) {
            defaultRequestOptions.setContext(testRunRequestOptions.getContext());
        }
        return new PollerFlux(Duration.ofSeconds(5L), context -> this.createOrUpdateTestRunWithResponse(testRunId, body, testRunRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono).flatMap(testRunBinary -> PollingUtils.getPollResponseMono(() -> PollingUtils.getTestRunStatus(testRunBinary))), (activationResponse, context) -> this.stopTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.serviceClient.listMetricsAsync(testRunId, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return this.serviceClient.listMetricDimensionValuesAsync(testRunId, name, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestRunWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunFileWithResponseAsync(testRunId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestRunsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricNamespacesWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return this.serviceClient.getMetricDefinitionsWithResponseAsync(testRunId, metricNamespace, requestOptions);
    }
}

