/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestAdministrationClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.LoadTestAdministrationsImpl;
import java.time.Duration;

@ServiceClient(builder=LoadTestAdministrationClientBuilder.class)
public final class LoadTestAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(LoadTestAdministrationClient.class);
    private final LoadTestAdministrationsImpl serviceClient;

    LoadTestAdministrationClient(LoadTestAdministrationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginUploadTestFile(String testId, String fileName, BinaryData body, RequestOptions fileUploadRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (fileUploadRequestOptions != null) {
            defaultRequestOptions.setContext(fileUploadRequestOptions.getContext());
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(2L), context -> PollingUtils.getValidationStatus((BinaryData)this.uploadTestFileWithResponse(testId, fileName, body, fileUploadRequestOptions).getValue()), context -> PollingUtils.getValidationStatus((BinaryData)this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).getValue()), (activationResponse, context) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, context -> (BinaryData)this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).getValue());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestFiles(String testId, RequestOptions requestOptions) {
        return this.serviceClient.listTestFiles(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateTestWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getTestWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTests(RequestOptions requestOptions) {
        return this.serviceClient.listTests(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> uploadTestFileWithResponse(String testId, String fileName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadTestFileWithResponse(testId, fileName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestFileWithResponse(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestFileWithResponse(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponse(testId, requestOptions);
    }
}

