/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.ScheduleFrequency;
import com.azure.developer.devcenter.models.ScheduleType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalTime;

public final class DevBoxSchedule
implements JsonSerializable<DevBoxSchedule> {
    private String name;
    private final ScheduleType scheduleType;
    private final ScheduleFrequency scheduleFrequency;
    private final LocalTime time;
    private final String timeZone;

    private DevBoxSchedule(ScheduleType scheduleType, ScheduleFrequency scheduleFrequency, LocalTime time, String timeZone) {
        this.scheduleType = scheduleType;
        this.scheduleFrequency = scheduleFrequency;
        this.time = time;
        this.timeZone = timeZone;
    }

    public String getName() {
        return this.name;
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public ScheduleFrequency getScheduleFrequency() {
        return this.scheduleFrequency;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.scheduleType == null ? null : this.scheduleType.toString());
        jsonWriter.writeStringField("frequency", this.scheduleFrequency == null ? null : this.scheduleFrequency.toString());
        jsonWriter.writeStringField("time", this.time.toString());
        jsonWriter.writeStringField("timeZone", this.timeZone);
        return jsonWriter.writeEndObject();
    }

    public static DevBoxSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxSchedule)jsonReader.readObject(reader -> {
            String name = null;
            ScheduleType scheduleType = null;
            ScheduleFrequency scheduleFrequency = null;
            LocalTime time = null;
            String timeZone = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    scheduleType = ScheduleType.fromString(reader.getString());
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    scheduleFrequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("time".equals(fieldName)) {
                    time = (LocalTime)reader.getNullable(nonNullReader -> LocalTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    timeZone = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            DevBoxSchedule deserializedDevBoxSchedule = new DevBoxSchedule(scheduleType, scheduleFrequency, time, timeZone);
            deserializedDevBoxSchedule.name = name;
            return deserializedDevBoxSchedule;
        });
    }
}

