/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.developer.devcenter.models.DevCenterOperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DevCenterOperationDetails
implements JsonSerializable<DevCenterOperationDetails> {
    private String id;
    private String name;
    private final DevCenterOperationStatus status;
    private String resourceId;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private Double percentComplete;
    private Object properties;
    private ResponseError error;

    private DevCenterOperationDetails(DevCenterOperationStatus status) {
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DevCenterOperationStatus getStatus() {
        return this.status;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public Double getPercentComplete() {
        return this.percentComplete;
    }

    public Object getProperties() {
        return this.properties;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeNumberField("percentComplete", (Number)this.percentComplete);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static DevCenterOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DevCenterOperationDetails)jsonReader.readObject(reader -> {
            String id = null;
            String name = null;
            DevCenterOperationStatus status = null;
            String resourceId = null;
            OffsetDateTime startTime = null;
            OffsetDateTime endTime = null;
            Double percentComplete = null;
            Object properties = null;
            ResponseError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = DevCenterOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    resourceId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    percentComplete = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readUntyped();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            DevCenterOperationDetails deserializedDevCenterOperationDetails = new DevCenterOperationDetails(status);
            deserializedDevCenterOperationDetails.id = id;
            deserializedDevCenterOperationDetails.name = name;
            deserializedDevCenterOperationDetails.resourceId = resourceId;
            deserializedDevCenterOperationDetails.startTime = startTime;
            deserializedDevCenterOperationDetails.endTime = endTime;
            deserializedDevCenterOperationDetails.percentComplete = percentComplete;
            deserializedDevCenterOperationDetails.properties = properties;
            deserializedDevCenterOperationDetails.error = error;
            return deserializedDevCenterOperationDetails;
        });
    }
}

