// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.data.tables.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The TableServiceMetrics model.
 */
@Fluent
public final class TableServiceMetrics implements XmlSerializable<TableServiceMetrics> {

    /*
     * The version of Analytics to configure.
     */
    private String version;

    /*
     * Indicates whether metrics are enabled for the Table service.
     */
    private boolean enabled;

    /*
     * Indicates whether metrics should generate summary statistics for called API operations.
     */
    private Boolean includeApis;

    /*
     * The retention policy.
     */
    private TableServiceRetentionPolicy retentionPolicy;

    /**
     * Creates an instance of TableServiceMetrics class.
     */
    public TableServiceMetrics() {
    }

    /**
     * Get the version property: The version of Analytics to configure.
     *
     * @return the version value.
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Set the version property: The version of Analytics to configure.
     *
     * @param version the version value to set.
     * @return the TableServiceMetrics object itself.
     */
    public TableServiceMetrics setVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the enabled property: Indicates whether metrics are enabled for the Table service.
     *
     * @return the enabled value.
     */
    public boolean isEnabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: Indicates whether metrics are enabled for the Table service.
     *
     * @param enabled the enabled value to set.
     * @return the TableServiceMetrics object itself.
     */
    public TableServiceMetrics setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     *
     * @return the includeApis value.
     */
    public Boolean isIncludeApis() {
        return this.includeApis;
    }

    /**
     * Set the includeApis property: Indicates whether metrics should generate summary statistics for called API
     * operations.
     *
     * @param includeApis the includeApis value to set.
     * @return the TableServiceMetrics object itself.
     */
    public TableServiceMetrics setIncludeApis(Boolean includeApis) {
        this.includeApis = includeApis;
        return this;
    }

    /**
     * Get the retentionPolicy property: The retention policy.
     *
     * @return the retentionPolicy value.
     */
    public TableServiceRetentionPolicy getTableServiceRetentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: The retention policy.
     *
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the TableServiceMetrics object itself.
     */
    public TableServiceMetrics setRetentionPolicy(TableServiceRetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "TableServiceMetrics" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeBooleanElement("IncludeAPIs", this.includeApis);
        xmlWriter.writeXml(this.retentionPolicy, "RetentionPolicy");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TableServiceMetrics from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of TableServiceMetrics if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceMetrics.
     */
    public static TableServiceMetrics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TableServiceMetrics from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TableServiceMetrics if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TableServiceMetrics.
     */
    public static TableServiceMetrics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "TableServiceMetrics" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceMetrics deserializedTableServiceMetrics = new TableServiceMetrics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.version = reader.getStringElement();
                } else if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.enabled = reader.getBooleanElement();
                } else if ("IncludeAPIs".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.includeApis = reader.getNullableElement(Boolean::parseBoolean);
                } else if ("RetentionPolicy".equals(elementName.getLocalPart())) {
                    deserializedTableServiceMetrics.retentionPolicy
                        = TableServiceRetentionPolicy.fromXml(reader, "RetentionPolicy");
                } else {
                    reader.skipElement();
                }
            }
            return deserializedTableServiceMetrics;
        });
    }
}
