/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.StorageConstants;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.sas.TableSasIpRange;
import com.azure.data.tables.sas.TableSasPermission;
import com.azure.data.tables.sas.TableSasProtocol;
import com.azure.data.tables.sas.TableSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Objects;

public class TableSasGenerator {
    private final ClientLogger logger = new ClientLogger(TableSasGenerator.class);
    private final OffsetDateTime expiryTime;
    private final OffsetDateTime startTime;
    private final String endPartitionKey;
    private final String endRowKey;
    private final String identifier;
    private final String sas;
    private final String startPartitionKey;
    private final String startRowKey;
    private final String tableName;
    private final TableSasProtocol protocol;
    private final TableSasIpRange sasIpRange;
    private String permissions;
    private String version;

    public TableSasGenerator(TableSasSignatureValues sasValues, String tableName, AzureNamedKeyCredential azureNamedKeyCredential) {
        Objects.requireNonNull(sasValues, "'sasValues' cannot be null.");
        Objects.requireNonNull(azureNamedKeyCredential, "'azureNamedKeyCredential' cannot be null.");
        this.version = sasValues.getVersion();
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.tableName = tableName;
        this.identifier = sasValues.getIdentifier();
        this.startPartitionKey = sasValues.getStartPartitionKey();
        this.startRowKey = sasValues.getStartRowKey();
        this.endPartitionKey = sasValues.getEndPartitionKey();
        this.endRowKey = sasValues.getEndRowKey();
        this.validateState();
        String canonicalName = this.getCanonicalName(azureNamedKeyCredential.getAzureNamedKey().getName());
        String stringToSign = this.stringToSign(canonicalName);
        String signature = TableSasUtils.computeHmac256(azureNamedKeyCredential.getAzureNamedKey().getKey(), stringToSign);
        this.sas = this.encode(signature);
    }

    public String getSas() {
        return this.sas;
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        TableSasUtils.tryAppendQueryParameter(sb, "sv", this.version);
        TableSasUtils.tryAppendQueryParameter(sb, "st", TableSasUtils.formatQueryParameterDate(this.startTime));
        TableSasUtils.tryAppendQueryParameter(sb, "se", TableSasUtils.formatQueryParameterDate(this.expiryTime));
        TableSasUtils.tryAppendQueryParameter(sb, "tn", this.tableName);
        TableSasUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        TableSasUtils.tryAppendQueryParameter(sb, "spk", this.startPartitionKey);
        TableSasUtils.tryAppendQueryParameter(sb, "srk", this.startRowKey);
        TableSasUtils.tryAppendQueryParameter(sb, "epk", this.endPartitionKey);
        TableSasUtils.tryAppendQueryParameter(sb, "erk", this.endRowKey);
        TableSasUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        TableSasUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        TableSasUtils.tryAppendQueryParameter(sb, "si", this.identifier);
        TableSasUtils.tryAppendQueryParameter(sb, "sig", signature);
        return sb.toString();
    }

    private void validateState() {
        if (this.version == null) {
            this.version = TableServiceVersion.getLatest().getVersion();
        }
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        if (this.permissions != null) {
            if (this.tableName != null) {
                this.permissions = TableSasPermission.parse(this.permissions).toString();
            } else {
                this.logger.info("Not re-parsing permissions. Resource type is not table.");
            }
        }
        if (this.startPartitionKey != null && this.startRowKey == null || this.startPartitionKey == null && this.startRowKey != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("'startPartitionKey' and 'startRowKey' must either be both provided or both null. One cannot be provided without the other."));
        }
        if (this.endPartitionKey != null && this.endRowKey == null || this.endPartitionKey == null && this.endRowKey != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("'endPartitionKey' and 'endRowKey' must either be both provided or both null. One cannot be provided without the other."));
        }
    }

    private String getCanonicalName(String account) {
        return String.join((CharSequence)"/", "/table", account, this.tableName);
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : StorageConstants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : StorageConstants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName.toLowerCase(Locale.ROOT), this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version, this.startPartitionKey == null ? "" : this.startPartitionKey, this.startRowKey == null ? "" : this.startRowKey, this.endPartitionKey == null ? "" : this.endPartitionKey, this.endRowKey == null ? "" : this.endRowKey);
    }
}

