/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.TableUtils;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableAccessPolicies;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableEntityUpdateMode;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.data.tables.models.TableTransactionAction;
import com.azure.data.tables.models.TableTransactionResult;
import com.azure.data.tables.sas.TableSasSignatureValues;
import java.time.Duration;
import java.util.List;

@ServiceClient(builder=TableClientBuilder.class)
public final class TableClient {
    final TableAsyncClient client;

    TableClient(TableAsyncClient client) {
        this.client = client;
    }

    public String getTableName() {
        return this.client.getTableName();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String getTableEndpoint() {
        return this.client.getTableEndpoint();
    }

    public TableServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public String generateSas(TableSasSignatureValues tableSasSignatureValues) {
        return this.client.generateSas(tableSasSignatureValues);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableItem createTable() {
        return (TableItem)this.client.createTable().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableItem> createTableWithResponse(Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.createTableWithResponse(context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTable() {
        this.client.deleteTable().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTableWithResponse(Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.deleteTableWithResponse(context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createEntity(TableEntity entity) {
        this.client.createEntity(entity).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createEntityWithResponse(TableEntity entity, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.createEntityWithResponse(entity, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upsertEntity(TableEntity entity) {
        this.client.upsertEntity(entity).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> upsertEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.upsertEntityWithResponse(entity, updateMode, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEntity(TableEntity entity) {
        this.client.updateEntity(entity).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEntity(TableEntity entity, TableEntityUpdateMode updateMode) {
        this.client.updateEntity(entity, updateMode).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateEntityWithResponse(TableEntity entity, TableEntityUpdateMode updateMode, boolean ifUnchanged, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.updateEntityWithResponse(entity, updateMode, ifUnchanged, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEntity(String partitionKey, String rowKey) {
        this.client.deleteEntity(partitionKey, rowKey).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEntity(TableEntity entity) {
        this.client.deleteEntity(entity).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteEntityWithResponse(TableEntity entity, boolean ifUnchanged, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.deleteEntityWithResponse(entity.getPartitionKey(), entity.getRowKey(), entity.getETag(), ifUnchanged, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableEntity> listEntities() {
        return new PagedIterable(this.client.listEntities());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TableEntity> listEntities(ListEntitiesOptions options, Duration timeout, Context context) {
        return new PagedIterable(TableUtils.applyOptionalTimeout(this.client.listEntities(options, context), timeout));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableEntity getEntity(String partitionKey, String rowKey) {
        return (TableEntity)this.client.getEntity(partitionKey, rowKey).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableEntity> getEntityWithResponse(String partitionKey, String rowKey, List<String> select, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.getEntityWithResponse(partitionKey, rowKey, select, TableEntity.class, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableAccessPolicies getAccessPolicies() {
        return (TableAccessPolicies)this.client.getAccessPolicies().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableAccessPolicies> getAccessPoliciesWithResponse(Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.getAccessPoliciesWithResponse(context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicies(List<TableSignedIdentifier> tableSignedIdentifiers) {
        this.client.setAccessPolicies(tableSignedIdentifiers).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPoliciesWithResponse(List<TableSignedIdentifier> tableSignedIdentifiers, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.setAccessPoliciesWithResponse(tableSignedIdentifiers, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableTransactionResult submitTransaction(List<TableTransactionAction> transactionActions) {
        return (TableTransactionResult)this.client.submitTransaction(transactionActions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TableTransactionResult> submitTransactionWithResponse(List<TableTransactionAction> transactionActions, Duration timeout, Context context) {
        return TableUtils.blockWithOptionalTimeout(this.client.submitTransactionWithResponse(transactionActions, context), timeout);
    }
}

