/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.json.jackson.implementation;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.serializer.json.jackson.implementation.JacksonDatabind212;
import com.azure.core.serializer.json.jackson.implementation.JacksonVersion;
import com.azure.core.serializer.json.jackson.implementation.ObjectMapperFactory;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import java.lang.reflect.Method;

public final class XmlMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(XmlMapperFactory.class);
    private static final String XML_MAPPER = "com.fasterxml.jackson.dataformat.xml.XmlMapper";
    private static final String XML_MAPPER_BUILDER = "com.fasterxml.jackson.dataformat.xml.XmlMapper$Builder";
    private static final String FROM_XML_PARSER = "com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser$Feature";
    private static final String TO_XML_GENERATOR = "com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator$Feature";
    private final ReflectiveInvoker createXmlMapperBuilder;
    private final ReflectiveInvoker defaultUseWrapper;
    private final ReflectiveInvoker configureWriteXmlDeclaration;
    private final Object writeXmlDeclaration;
    private final ReflectiveInvoker configureEmptyElementAsNull;
    private final Object emptyElementAsNull;
    private final boolean useJackson212;
    private boolean jackson212IsSafe = true;
    public static final XmlMapperFactory INSTANCE = new XmlMapperFactory();

    private XmlMapperFactory() {
        Object emptyElementAsNull;
        ReflectiveInvoker configureEmptyElementAsNull;
        Object writeXmlDeclaration;
        ReflectiveInvoker configureWriteXmlDeclaration;
        ReflectiveInvoker defaultUseWrapper;
        ReflectiveInvoker createXmlMapperBuilder;
        try {
            Class<?> xmlMapper = Class.forName(XML_MAPPER);
            Class<?> xmlMapperBuilder = Class.forName(XML_MAPPER_BUILDER);
            Class<?> fromXmlParser = Class.forName(FROM_XML_PARSER);
            Class<?> toXmlGenerator = Class.forName(TO_XML_GENERATOR);
            createXmlMapperBuilder = ReflectionUtils.getMethodInvoker(xmlMapper, (Method)xmlMapper.getDeclaredMethod("builder", new Class[0]), (boolean)false);
            defaultUseWrapper = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, (Method)xmlMapperBuilder.getDeclaredMethod("defaultUseWrapper", Boolean.TYPE), (boolean)false);
            configureWriteXmlDeclaration = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, (Method)xmlMapperBuilder.getDeclaredMethod("configure", toXmlGenerator, Boolean.TYPE), (boolean)false);
            writeXmlDeclaration = toXmlGenerator.getDeclaredField("WRITE_XML_DECLARATION").get(null);
            configureEmptyElementAsNull = ReflectionUtils.getMethodInvoker(xmlMapperBuilder, (Method)xmlMapperBuilder.getDeclaredMethod("configure", fromXmlParser, Boolean.TYPE), (boolean)false);
            emptyElementAsNull = fromXmlParser.getDeclaredField("EMPTY_ELEMENT_AS_NULL").get(null);
        }
        catch (Throwable ex) {
            if (ex instanceof Error && !(ex instanceof LinkageError)) {
                throw (Error)ex;
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Failed to retrieve invokers used to create XmlMapper. XML serialization won't be supported until 'com.fasterxml.jackson.dataformat:jackson-dataformat-xml' is added to the classpath or updated to a supported version. " + JacksonVersion.getHelpInfo(), ex));
        }
        this.createXmlMapperBuilder = createXmlMapperBuilder;
        this.defaultUseWrapper = defaultUseWrapper;
        this.configureWriteXmlDeclaration = configureWriteXmlDeclaration;
        this.writeXmlDeclaration = writeXmlDeclaration;
        this.configureEmptyElementAsNull = configureEmptyElementAsNull;
        this.emptyElementAsNull = emptyElementAsNull;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    public ObjectMapper createXmlMapper() {
        ObjectMapper xmlMapper;
        try {
            MapperBuilder<?, ?> xmlMapperBuilder = ObjectMapperFactory.initializeMapperBuilder((MapperBuilder)this.createXmlMapperBuilder.invokeStatic(new Object[0]));
            this.defaultUseWrapper.invokeWithArguments(xmlMapperBuilder, new Object[]{false});
            this.configureWriteXmlDeclaration.invokeWithArguments(xmlMapperBuilder, new Object[]{this.writeXmlDeclaration, true});
            this.configureEmptyElementAsNull.invokeWithArguments(xmlMapperBuilder, new Object[]{this.emptyElementAsNull, true});
            xmlMapper = xmlMapperBuilder.build();
        }
        catch (Exception ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unable to create XmlMapper instance.", ex));
        }
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                return JacksonDatabind212.mutateXmlCoercions(xmlMapper);
            }
            catch (Throwable ex) {
                if (ex instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, ex);
                }
                throw ex;
            }
        }
        return xmlMapper;
    }
}

