/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.avro.apache;

import com.azure.core.experimental.serializer.AvroSerializer;
import com.azure.core.serializer.avro.apache.ApacheAvroSerializer;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificData;

public class ApacheAvroSerializerBuilder {
    private String schema;
    private DecoderFactory decoderFactory;
    private EncoderFactory encoderFactory;
    private SpecificData specificData;

    public AvroSerializer build() {
        Objects.requireNonNull(this.schema, "'schema' cannot be null.");
        DecoderFactory buildDecoderFactory = this.decoderFactory == null ? DecoderFactory.get() : this.decoderFactory;
        EncoderFactory buildEncoderFactory = this.encoderFactory == null ? EncoderFactory.get() : this.encoderFactory;
        SpecificData buildSpecificData = this.specificData == null ? SpecificData.get() : this.specificData;
        return new ApacheAvroSerializer(new Schema.Parser().parse(this.schema), buildDecoderFactory, buildEncoderFactory, buildSpecificData);
    }

    public ApacheAvroSerializerBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public ApacheAvroSerializerBuilder decoderFactory(DecoderFactory decoderFactory) {
        this.decoderFactory = decoderFactory;
        return this;
    }

    public ApacheAvroSerializerBuilder encoderFactory(EncoderFactory encoderFactory) {
        this.encoderFactory = encoderFactory;
        return this;
    }

    public ApacheAvroSerializerBuilder specificData(SpecificData specificData) {
        this.specificData = specificData;
        return this;
    }
}

