/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.serializer.avro.apache;

import com.azure.core.experimental.serializer.AvroSerializer;
import com.azure.core.experimental.serializer.AvroSerializerProvider;
import com.azure.core.serializer.avro.apache.ApacheAvroSerializerBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;

public class ApacheAvroSerializerProvider
implements AvroSerializerProvider {
    private static final Schema NULL_SCHEMA;
    private static final Schema BYTE_BUFFER_SCHEMA;
    private static final Map<Class<?>, Schema> CLASS_SCHEMA_CACHE;
    private static final ClientLogger LOGGER;
    private static final String UNSUPPORTED_TYPE_EXCEPTION = "Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord";

    public AvroSerializer createInstance(String schema) {
        return new ApacheAvroSerializerBuilder().schema(schema).build();
    }

    public String getSchema(Object object) {
        return ApacheAvroSerializerProvider.computeOrGet(object).toString();
    }

    public String getSchemaName(Object object) {
        return ApacheAvroSerializerProvider.computeOrGet(object).getFullName();
    }

    private static Schema computeOrGet(Object object) {
        if (object == null) {
            return NULL_SCHEMA;
        }
        if (ByteBuffer.class.isAssignableFrom(object.getClass())) {
            return BYTE_BUFFER_SCHEMA;
        }
        return CLASS_SCHEMA_CACHE.computeIfAbsent(object.getClass(), k -> {
            if (GenericContainer.class.isAssignableFrom((Class<?>)k)) {
                return ((GenericContainer)object).getSchema();
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(UNSUPPORTED_TYPE_EXCEPTION));
        });
    }

    private static void addPrimitiveSchema(Schema primitiveSchema, Class<?> ... associatedClasses) {
        for (Class<?> associatedClass : associatedClasses) {
            CLASS_SCHEMA_CACHE.put(associatedClass, primitiveSchema);
        }
    }

    static {
        LOGGER = new ClientLogger(ApacheAvroSerializerProvider.class);
        NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        BYTE_BUFFER_SCHEMA = Schema.create((Schema.Type)Schema.Type.BYTES);
        CLASS_SCHEMA_CACHE = new ConcurrentHashMap();
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.BOOLEAN), Boolean.TYPE, Boolean.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.INT), Integer.TYPE, Integer.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.LONG), Long.TYPE, Long.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.FLOAT), Float.TYPE, Float.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.DOUBLE), Double.TYPE, Double.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.STRING), CharSequence.class, String.class);
        ApacheAvroSerializerProvider.addPrimitiveSchema(Schema.create((Schema.Type)Schema.Type.BYTES), byte[].class);
    }
}

