/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.vertx.implementation.VertxHttpResponseBase;
import com.azure.core.util.BinaryData;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BufferedVertxHttpResponse
extends VertxHttpResponseBase {
    private final byte[] body;

    public BufferedVertxHttpResponse(HttpRequest azureHttpRequest, HttpClientResponse vertxHttpResponse, Buffer body) {
        super(azureHttpRequest, vertxHttpResponse);
        this.body = body.getBytes();
    }

    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromBytes((byte[])this.body);
    }

    public Flux<ByteBuffer> getBody() {
        return this.body.length == 0 ? Flux.empty() : Flux.just((Object)ByteBuffer.wrap(this.body));
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return this.body.length == 0 ? Mono.empty() : Mono.just((Object)this.body);
    }

    public HttpResponse buffer() {
        return this;
    }
}

