/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.vertx;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.vertx.implementation.BufferedVertxHttpResponse;
import com.azure.core.http.vertx.implementation.VertxHttpResponse;
import com.azure.core.http.vertx.implementation.VertxRequestWriteSubscriber;
import com.azure.core.http.vertx.implementation.VertxUtils;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.ByteBufferContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class VertxHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(VertxHttpClient.class);
    final io.vertx.core.http.HttpClient client;
    private final Duration responseTimeout;

    VertxHttpClient(io.vertx.core.http.HttpClient client, Duration responseTimeout) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.responseTimeout = responseTimeout;
    }

    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, com.azure.core.util.Context.NONE);
    }

    public Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context context) {
        return Mono.deferContextual(contextView -> Mono.fromFuture(this.sendInternal(request, context, (ContextView)contextView))).onErrorMap(VertxUtils::wrapVertxException);
    }

    public HttpResponse sendSync(HttpRequest request, com.azure.core.util.Context context) {
        try {
            return this.sendInternal(request, context, (ContextView)Context.empty()).get();
        }
        catch (Exception e) {
            Throwable mapped = e;
            if (e instanceof ExecutionException) {
                mapped = e.getCause();
            }
            if ((mapped = VertxUtils.wrapVertxException(mapped)) instanceof Error) {
                throw (Error)LOGGER.logThrowableAsError((Throwable)((Error)mapped));
            }
            if (mapped instanceof IOException) {
                throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException((IOException)mapped));
            }
            if (mapped instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)mapped);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(mapped));
        }
    }

    private CompletableFuture<HttpResponse> sendInternal(HttpRequest request, com.azure.core.util.Context context, ContextView contextView) {
        boolean eagerlyReadResponse = context.getData((Object)"azure-eagerly-read-response").orElse(false);
        boolean ignoreResponseBody = context.getData((Object)"azure-ignore-response-body").orElse(false);
        Duration perCallTimeout = (Duration)context.getData((Object)"azure-response-timeout").filter(timeoutDuration -> timeoutDuration instanceof Duration).orElse(this.responseTimeout);
        ProgressReporter progressReporter = Contexts.with((com.azure.core.util.Context)context).getHttpRequestProgressReporter();
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.valueOf((String)request.getHttpMethod().name())).setAbsoluteURI(request.getUrl());
        Promise promise = Promise.promise();
        this.client.request(options, requestResult -> {
            if (requestResult.failed()) {
                promise.fail(requestResult.cause());
                return;
            }
            HttpClientRequest vertxRequest = (HttpClientRequest)requestResult.result();
            for (HttpHeader header : request.getHeaders()) {
                vertxRequest.putHeader(header.getName(), (Iterable)header.getValuesList());
            }
            if (request.getHeaders().get(HttpHeaderName.CONTENT_LENGTH) == null) {
                vertxRequest.setChunked(true);
            }
            Future responseFuture = !perCallTimeout.isZero() && !perCallTimeout.isNegative() ? vertxRequest.response().timeout(perCallTimeout.toMillis(), TimeUnit.MILLISECONDS) : vertxRequest.response();
            responseFuture = responseFuture.onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
            if (eagerlyReadResponse || ignoreResponseBody) {
                responseFuture.andThen(responseResult -> {
                    if (responseResult.failed()) {
                        promise.fail(responseResult.cause());
                        return;
                    }
                    HttpClientResponse vertxHttpResponse = (HttpClientResponse)responseResult.result();
                    vertxHttpResponse.body().andThen(bodyResult -> {
                        if (bodyResult.succeeded()) {
                            promise.complete((Object)new BufferedVertxHttpResponse(request, vertxHttpResponse, (Buffer)bodyResult.result()));
                        } else {
                            promise.fail(bodyResult.cause());
                        }
                    });
                });
            } else {
                responseFuture.andThen(responseResult -> {
                    if (responseResult.succeeded()) {
                        promise.complete((Object)new VertxHttpResponse(request, (HttpClientResponse)responseResult.result()));
                    } else {
                        promise.fail(responseResult.cause());
                    }
                });
            }
            this.sendBody(contextView, request, progressReporter, vertxRequest, (Promise<HttpResponse>)promise);
        });
        return promise.future().toCompletionStage().toCompletableFuture();
    }

    private void sendBody(ContextView contextView, HttpRequest azureRequest, ProgressReporter progressReporter, HttpClientRequest vertxRequest, Promise<HttpResponse> promise) {
        BinaryData body = azureRequest.getBodyAsBinaryData();
        if (body == null) {
            vertxRequest.send().onFailure(arg_0 -> promise.fail(arg_0));
        } else {
            BinaryDataContent bodyContent = BinaryDataHelper.getContent((BinaryData)body);
            if (bodyContent instanceof ByteArrayContent || bodyContent instanceof ByteBufferContent || bodyContent instanceof StringContent || bodyContent instanceof SerializableContent) {
                long contentLength = bodyContent.getLength();
                vertxRequest.send(Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)bodyContent.toByteBuffer()))).onSuccess(ignored -> VertxHttpClient.reportProgress(contentLength, progressReporter)).onFailure(arg_0 -> promise.fail(arg_0));
            } else {
                azureRequest.getBody().subscribe((Subscriber)new VertxRequestWriteSubscriber(vertxRequest, promise, progressReporter, contextView));
            }
        }
    }

    private static void reportProgress(long progress, ProgressReporter progressReporter) {
        if (progressReporter != null) {
            progressReporter.reportProgress(progress);
        }
    }
}

