/*
 * Decompiled with CFR 0.152.
 */
package com.azure.compute.batch.models;

import com.azure.compute.batch.models.ImageReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VirtualMachineInfo
implements JsonSerializable<VirtualMachineInfo> {
    private ImageReference imageReference;
    private String scaleSetVmResourceId;

    private VirtualMachineInfo() {
    }

    public ImageReference getImageReference() {
        return this.imageReference;
    }

    public String getScaleSetVmResourceId() {
        return this.scaleSetVmResourceId;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeStringField("scaleSetVmResourceId", this.scaleSetVmResourceId);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineInfo fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineInfo)jsonReader.readObject(reader -> {
            VirtualMachineInfo deserializedVirtualMachineInfo = new VirtualMachineInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineInfo.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("scaleSetVmResourceId".equals(fieldName)) {
                    deserializedVirtualMachineInfo.scaleSetVmResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineInfo;
        });
    }
}

